![Notification Banner](NotificationBanner/Assets/header.png)

[![Version](https://img.shields.io/cocoapods/v/NotificationBanner.svg?style=flat)](http://cocoapods.org/pods/NotificationBanner)
[![Platform](https://img.shields.io/cocoapods/p/NotificationBanner.svg?style=flat)](http://cocoapods.org/pods/NotificationBanner)
<a href="https://developer.apple.com/swift"><img src="https://img.shields.io/badge/swift-3.0-4BC51D.svg?style=flat" alt="Language: Swift" /></a>
[![License](https://img.shields.io/cocoapods/l/NotificationBanner.svg?style=flat)](http://cocoapods.org/pods/NotificationBanner)

## Written in Swift 3

NotificationBanner is an extremely customizable and lightweight library that makes the task of displaying in app notification banners and drop down alerts an absolute breeze in iOS.

| Basic Banners | Banners with Side Views  | Status Bar Banners |
| ------------- | ------------- | ------------- |
| ![Basic Banners](NotificationBanner/Assets/basic.gif)  | ![Banners with Side Views](NotificationBanner/Assets/side_views.gif)  | ![Status Bar Banners](NotificationBanner/Assets/status_bar.gif) |

## Features
- Highly customizable ✅
- `NSAttributedString` support ✅
- iPhone & iPad Support ✅
- Orientation change support ✅
- Custom `UIView` support ✅
- Scrolling label support for banners with long titles/subtitles ✅
- Built in banner queue ✅

## Requirements

 - iOS 9.0+
 - xCode 8.1+

## Installation

NotificationBanner is available through [CocoaPods](http://cocoapods.org). To install
it, simply add the following line to your Podfile:

```ruby
pod 'NotificationBanner'
```

## Usage

Creating drop down alerts with NotificationBanner is easy. To create and show a banner, simply:

```swift
let banner = NotificationBanner(title: title, subtitle: subtitle, style: .success)
banner.show()
```

To create a status bar alert, simply:

```swift
let banner = StatusBarNotificationBanner(title: title, style: .success)
banner.show()
```

By default, each banner will automatically dismiss after 5 seconds. To dismiss programatically, simply:

```swift
banner.dismiss()
```

NotificationBanner has five prebuilt styles that you can choose from:

```swift
public enum BannerStyle {
    case danger
    case info
    case none
    case success
    case warning
}
```

By default, the `.info` style will be applied to the banner if no style is provided in the init method. You can set the background color of a banner at any time by simply setting the `backgroundColor`.

### Banners with Side Views

A notification banner can have a left acessory view, a right acessory view, or both:

```swift
// Success Style Notification with Left View
let leftView = UIImageView(image: #imageLiteral(resourceName: "success"))
let banner = NotificationBanner(title: title, subtitle: subtitle, leftView: leftView, style: .success)
banner.show()

 // Danger Style Notification with Right View
let rightView = UIImageView(image: #imageLiteral(resourceName: "danger"))
let banner = NotificationBanner(title: title, subtitle: subtitle, rightView: rightView, style: .danger)
banner.show()    
        
// Info Style Notification with Left and Right Views
let leftView = UIImageView(image: #imageLiteral(resourceName: "info"))
let rightView = UIImageView(image: #imageLiteral(resourceName: "right_chevron"))
let banner = NotificationBanner(title: title, subtitle: subtitle, leftView: leftView, rightView: rightView, style: .info)
banner.show()
```
![Banners with Side Views](NotificationBanner/Assets/side_views.gif)

Each side view will be automically reisized to fit perfectly

### Banners with a Custom View

A notification banner can also be initalized with a custom view:

```swift
let banner = NotificationBanner(customView: NorthCarolinaBannerView())
banner.show()
```
![Custom Banner](NotificationBanner/Assets/custom.gif)

### Handling User Interaction

By default, when a banner is tapped by a user, it will be dismissed. If you want to detect when the user taps a banner, simply:

```swift
banner.onTap = {
	// Do something regarding the banner
}
```

## Banner Queue

By default, each notification banner is placed onto a `NotificationBannerQueue`. This allows an infinite amount of banners to be de displayed without one hiding the other. By default, each notification banner is placed on the back of the queue. If you would rather place the banner in the front and show it immediately no matter how many banners are in the queue, simply state it in the `show()` method:

```swift
banner.show(queuePosition: .front)
```

Adding a banner to the front of the queue will temporarily suspend the currently displayed banner (if there is one) and will resume it after the banner in front of it dismisses. 

 <b>This is all automatically managed!</b>

## Feature Requests

I'd love to know anything that you think NotificationBanner is missing. Open an issue and add the `feature request` tag to it and I'll do everything I can to accomodate that request if it is in the library's best interest. 😄 

## Author

Dalton Hinterscher, daltonhint4@gmail.com

## License

NotificationBanner is available under the MIT license. See the LICENSE file for more info.
