﻿#pragma once

static LPCTSTR en_us[] {
    "First Person Field of View",
    "First Person Unarmed Reticle",
    "First Person Min Pitch Angle",
    "First Person Max Pitch Angle",
    "First Person Aiming Field of View",
    "Third Person Field of View",
    "Third Person Auto Center",
    "Third Person Horizontal Origin",
    "Third Person Vertical Origin",
    "Third Person Follow Distance",
    "Third Person Running Shake",
    "Third Person Min Pitch Angle",
    "Third Person Max Pitch Angle",
    "Third Person Aiming Field of View",
    "Third Person Aiming Horizontal Origin",
    "Third Person Aiming Follow Distance",
    "First Person Vehicle Field of View",
    "First Person Vehicle Vertical Origin",
    "First Person Vehicle Switch In Water",
    "First Person Vehicle Switch on Destroyed",
    "First Person Vehicle Min Pitch Angle",
    "First Person Vehicle Max Pitch Angle",
    "Third Person Vehicle Field of View",
    "Third Person Vehicle Min Pitch Angle",
    "Third Person Vehicle Max Pitch Angle",
    "Third Person Vehicle Auto Center",
    "Third Person Vehicle Follow Distance",
    "Third Person Vehicle Speed Zoom",
    "Third Person Vehicle Pivot Scale",
    "Third Person Vehicle Horizontal Origin",
    "Third Person Vehicle High Speed Shake"
};

static LPCTSTR en_es[] {
    u8"Campo de visión en Primera Persona",
    u8"Usar siempre el retículo en Primera Persona",
    u8"Ángulo de Inclinación Mínimo en Primera Persona",
    u8"Ángulo de Inclinación Máximo en Primera Persona",
    u8"Campo de Visión Apuntando en Primera Persona",
    u8"Campo de Visión en Tercera Persona",
    u8"Centro de auto de Tercera Persona",
    u8"Origen Horizontal en Tercera Persona",
    u8"Origen Vertical en Tercera Persona",
    u8"Distancia de Seguimiento en Tercera Persona",
    u8"Agitación Corriendo en Tercera Persona",
    u8"Ángulo de Inclinación Mínimo en Tercera Persona",
    u8"Ángulo de Inclinación Máximo en Tercera Persona",
    u8"Campo de Visión Apuntando en Tercera Persona",
    u8"Origen Horizontal Apuntando en Tercera Persona",
    u8"Distancia de Seguimiento Apuntando en Tercera Persona",
    u8"Campo de Visión de Vehículo en Primera Persona",
    u8"Origen Vertical de Vehículo en Primera Persona",
    u8"Cambiar la Primera Persona de Vehículo en Agua",
    u8"Cambiar la Primera Persona del Vehículo Destruido",
    u8"Ángulo de Inclinación Mínimo en Vehículo en Primera Persona",
    u8"Ángulo de Inclinación Máximo en Vehículo en Primera Persona",
    u8"Campo de Visión en Vehículo en Tercera Persona",
    u8"Ángulo de Inclinación Mínimo en Vehículo en Tercera Persona",
    u8"Ángulo de Inclinación Máximo en Vehículo en Tercera Persona",
    u8"Auto - centrado en Vehículo en Tercera Persona",
    u8"Distancia de seguimiento de Vehículo en Tercera Persona",
    u8"Velocidad del vehículo de la tercera persona zoom relativo",
    u8"Escala del Pivote del Vehículo en Tercera Persona",
    u8"Origen Horizontal en Vehículo en Tercera Persona",
    u8"Agitación de Alta Velocidad en Vehículo en Tercera Persona"
};

static LPCTSTR ru_ru[]{
    u8"Поле Обзора Камеры (Первое Лицо)",
    u8"Всегда Отображать Прицел (Первое Лицо)",
    u8"Минимальный Угол Наклона Камеры (Первое Лицо)",
    u8"Максимальный Угол Наклона Камеры (Первое Лицо)",
    u8"Поле Обзора Камеры при Прицеливании (Первое Лицо)",
    u8"Поле Обзора Камеры (Третье Лицо)",
    u8"Автоцентровка Камеры (Третье Лицо)",
    u8"Отношение Камеры по Горизонтали (Третье Лицо)",
    u8"Отношение Камеры по Вертикали (Третье Лицо)",
    u8"Дистанция Камеры Пешком (Третье Лицо)",
    u8"Дрожание Камеры во Время Бега (Третье Лицо)",
    u8"Минимальный Угол Наклона Камеры (Третье Лицо)",
    u8"Максимальный Угол Наклона Камеры (Третье Лицо)",
    u8"Поле Обзора во Время Прицеливания (Третье Лицо)",
    u8"Отношение Камеры во Время Стрельбы по Горизонтали (Третье Лицо)",
    u8"Дистанция Камеры во Время Стрельбы (Третье Лицо)",
    u8"Поле Обзора Камеры в Транспорте (Первое Лицо)",
    u8"Отношение Камеры в Транспорте по Вертикали (Первое Лицо)",
    u8"Не Переключать Камеру, Когда Транспорт в Воде (Первое Лицо)",
    u8"Не Переключать Камеру, Когда Транспорт Уничтожен (Первое Лицо)",
    u8"Минимальный Угол Наклона Камеры в Транспорте (Первое Лицо)",
    u8"Максимальный Угол Наклона Камеры в Транспорте (Первое Лицо)",
    u8"Поле Обзора Камеры в Транспорте (Третье Лицо)",
    u8"Минимальный Угол Наклона Камеры в Транспорте (Третье Лицо)",
    u8"Максимальный Угол Наклона Камеры в Транспорте (Третье Лицо)",
    u8"Автоцентровка Камеры в Транспорте во Время Езды (Третье Лицо)",
    u8"Дистанция Камеры в Транспорте (Третье Лицо)",
    u8"Отдаление Камеры в Транспорте на Высоких Скоростях (Третье Лицо)",
    u8"Высота Камеры в Транспорте (Третье Лицо)",
    u8"Отношение Камеры в Транспорте по Горизонтали (Третье Лицо)",
    u8"Дрожание Камеры в Транспорте на Высоких Скоростях (Третье Лицо)"
};

static LPCTSTR zh_cn[] {
    u8"第一人称视野",
    u8"第一人称无瞄准准星",
    u8"第一人称最小俯仰角",
    u8"第一人称最大俯仰角",
    u8"第一人称瞄准视野",
    u8"第三人称视野",
    u8"第三人称自动居中",
    u8"第三人称横向源点",
    u8"第三人称垂直源点",
    u8"第三人称跟随距离",
    u8"第三人称奔跑震动",
    u8"第三人称最小俯仰角",
    u8"第三人称最大俯仰角",
    u8"第三人称瞄准视野",
    u8"第三人称瞄准横向原点",
    u8"第三人称瞄准跟随距离",
    u8"第一人称驾驶视野",
    u8"第一人称驾驶垂直原点",
    u8"在水中时切换第一人称驾驶视角",
    u8"死亡时切换第一人称驾驶视角",
    u8"第一人称驾驶最小俯仰角",
    u8"第一人称驾驶最大俯仰角",
    u8"第三人称驾驶视野",
    u8"第三人称驾驶最小俯仰角",
    u8"第三人称驾驶最大俯仰角",
    u8"第三人称驾驶自动居中",
    u8"第三人称驾驶跟随距离",
    u8"第三人称驾驶车辆速度变焦",
    u8"第三人称驾驶轴心缩放",
    u8"第三人称驾驶横向原点",
    u8"第三人称驾驶车辆高速抖动"
};

static LPCTSTR pt_br[] {
    u8"Campo de Visão da Câmera (Primeira Pessoa)",
    u8"Sempre Exibir Mira (Primeira Pessoa)",
    u8"Ângulo Mínimo da Câmera (Primeira Pessoa)",
    u8"Ângulo Máximo da Câmera (Primeira Pessoa)",
    u8"Campo de Visão da Câmera ao Mirar (Primeira Pessoa)",
    u8"Campo de Visão da Câmera (Terceira Pessoa)",
    u8"Centralização Automática da Câmera (Terceira Pessoa)",
    u8"Origem Horizontal da Câmera (Terceira Pessoa)",
    u8"Origem Vertical da Câmera (Terceira Pessoa)",
    u8"Distância da Câmera (Terceira Pessoa)",
    u8"Tremor de Câmera ao Correr (Terceira Pessoa)",
    u8"Ângulo Mínimo da Câmera (Terceira Pessoa)",
    u8"Ângulo Máximo da Câmera (Terceira Pessoa)",
    u8"Campo de Visão ao Mirar (Terceira Pessoa)",
    u8"Origem Horizontal da Câmera ao Mirar (Terceira Pessoa)",
    u8"Distância da Câmera ao Mirar (Terceira Pessoa)",
    u8"Campo de Visão da Câmera Dentro do Veículo (Primeira Pessoa)",
    u8"Origem Vertical da Câmera Dentro do Veículo (Primeira Pessoa)",
    u8"Alterar para a Câmera em Terceira Pessoa, Quando o Veículo Estiver na Água (Primeira Pessoa)",
    u8"Alterar para a Câmera em Terceira Pessoa, Quando o Veículo for Destruído (Primeira Pessoa)",
    u8"Ângulo Mínimo da Câmera Dentro do Veículo (Primeira Pessoa)",
    u8"Ângulo Máximo de Inclinação da Câmera Dentro do Veículo (Primeira Pessoa)",
    u8"Campo de Visão da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Ângulo Mínimo da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Ângulo Máximo da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Centralização Automática da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Distância da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Distância da Câmera Dentro do Veículo em Alta Velocidade (Terceira Pessoa)",
    u8"Altura da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Origem Horizontal da Câmera Dentro do Veículo (Terceira Pessoa)",
    u8"Tremor de Câmera Dentro do Veículo em Alta Velocidade (Terceira Pessoa)"
};

enum GlobalTextEntry_t {
    MO_FP_FOV,
    MO_FP_USE_RETICLE,
    MO_FP_MIN_PITCH,
    MO_FP_MAX_PITCH,
    MO_FP_AIMING_FOV,
    MO_TP_FOV,
    MO_TP_AUTO_CENTER,
    MO_TP_HORZ_OFF,
    MO_TP_VERT_OFF,
    MO_TP_FOLLOW_DIST,
    MO_TP_SHAKE,
    MO_TP_MIN_PITCH,
    MO_TP_MAX_PITCH,
    MO_TP_AIMING_FOV,
    MO_TP_AIMING_HORZ_OFF,
    MO_TP_AIMING_FOLLOW_DIST,
    MO_FP_VEHICLE_FOV,
    MO_FP_VEHICLE_VERT_OFF,
    MO_FP_VEHICLE_SWITCH_WATER,
    MO_FP_VEHICLE_SWITCH_DAMAGE,
    MO_FP_VEHICLE_MIN_PITCH,
    MO_FP_VEHICLE_MAX_PITCH,
    MO_TP_VEHICLE_FOV,
    MO_TP_VEHICLE_MIN_PITCH,
    MO_TP_VEHICLE_MAX_PITCH,
    MO_TP_VEHICLE_AUTO_CENTER,
    MO_TP_VEHICLE_FOLLOW_DIST,
    MO_TP_VEHICLE_SPEED_ZOOM,
    MO_TP_VEHICLE_PIVOT_SCALE,
    MO_TP_VEHICLE_HORZ_OFF,
    MO_TP_VEHICLE_SHAKE
};

static LPCTSTR* langtext_array[5] {
    en_us,
    en_es,
    ru_ru,
    zh_cn,
    pt_br
};

inline LPCTSTR getConstString(int langugageId, GlobalTextEntry_t textId) {
    return langtext_array[langugageId][textId];
}
