_You can download previous versions [here](https://github.com/AliSoftware/OHHTTPStubs/tags) and latest version [here](https://github.com/AliSoftware/OHHTTPStubs/zipball/master) (ZIP files generated by GitHub on the fly)_

## [3.1.1](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.1.1)

* Fixing a crash when using very very long data #57/#59
* Fixing issue #51 regarding a probable race condition when stubs were removed before the request has finished
* Shorten the README.md file and moved all the usage examples in a dedicated wiki page to avoid a endless and frightening README

## [3.1.0](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.1.0)

* The `OHHTTPStubsDescriptor` protocol now inherits from the `NSObject` protocol

## [3.0.4](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.0.4)

Fixing issue #47 when stubs were not called, especially when the `OHHTTPStubs` pod were loaded both by the application AND the test target/bundle. See also [[A tricky case with Application Tests]].

* `NSURLSessionConfiguration` 's swizzling (to add automatic support of `OHHTTPStubs` to `NSURLSession`) is now done in the `+load` method of an `NSURLSessionConfiguration` category, to be sure it is loaded (and swizzled) only once, even if `OHHTTPStubs` is loaded by two different bundles.
* The stubs activation of `NSURLSessionConfiguration` no longer uses `objc_getClass` but uses a call to the `OHHTTPStubs` class instead, which ensure that it uses the correct `OHHTTPStubs` class in the current bundle instead of always using the one loaded from the main bundle.

## [3.0.3](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.0.3)

* Adding Mac framework & Mac Test Target (#44)
* Adding known limitations in README

## [3.0.2](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.0.2)

* Fixed issue with cookies when `request.URL` is `nil` ([#39](https://github.com/AliSoftware/OHHTTPStubs/pull/39))
* Fixed missing `-ObjC` flag in Unit Tests target _(that made it unable to call category methods)_
* Fixed Unit Tests on iOS6 _(`NSURLSession`-related Unit Tests now only executed when run on iOS7+ or OSX10.9+, and skipped if targeted for an earlier OS version, as `NSURLSession` was not available then)_

## [3.0.1](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.0.1)

* Fixed issue with `NSURLSessionConfiguration` auto-swizzling (#37 & #38)

> _Now `OHHTTPStubs` automagically works with `NSURLSessionConfiguration` **without the need** to enable it for every `NSURLSessionConfiguration` before creating the `NSURLSession`: the `defaultSessionConfiguration` and `ephemeralSessionConfiguration` are now preconfigured automatically to work with `OHHTTPStubs`)_

## [3.0.0](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/3.0.0)

* Removed deprecated methods.

> The Old API has now totally disappeared, leaving only a clean and simple API without the spam due to old deprecated methods.

Note: **If you have already removed the calls to all `OHHTTPStubs` deprecated API in your code, you can switch to this `3.0.0` version without any further changes in your code**.

## [2.4.0](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/2.4.0)

* Added support for `NSURLSession` (thx to @ndonald2) [#31](https://github.com/AliSoftware/OHHTTPStubs/issues/31) [#34](https://github.com/AliSoftware/OHHTTPStubs/issues/34)

## [2.3.1](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/2.3.1)

* Fixed bug with OHHTTPStubsResponse+JSON when `nil` headers dictionary

## [2.3.0](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/2.3.0)

* Added the ability to give a name to a stub, for debugging purposes (property `name` of `id<OHHTTPStubsDescriptor>`)
* Added `allStubs` method to list all installed stubs (with their name if they have one, see previous point)
* Added `+[OHHTTPStubs onStubActivation:]` method to execute arbitrary code each time a stub is activated. Useful to log which stub is used for each request for example.

## [2.2.1](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/2.2.1)

* Complete refactoring to use `NSInputStream` instead of direct use of `NSData` (Thanks to @kcharwood - #28)
* Some other code refactoring to split the code in categories and make it clearer
* Some API changes to make `OHHTTPStubs` to fit the new possibility of setting both `requestTime` and `responseTime`.
  * Old API is still there but deprecated, and will be removed in next major version
  * To convert to the new API, you will mainly simply:
     * extract the `responseTime:` parameter to a method call of its own (`return [OHHTTPStubsResponse responseWithData:data statusCode:code responseTime:time headers:header];` will become `return [[OHHTTPStubsResponse responseWithData:data statusCode:code headers:headers] responseTime:time];` etc.)
     * convert `responseWithFile:filename` to `responseWithFileAtPath:OHPathForFileInBundle(filename,nil)`

> Note: version `2.1.0-RC`, `2.1.0-rc.1`, `2.2.0-RC` and `2.2.1-RC` were intermediate Release Candidate versions during the big refactoring and migration to `2.2.1`, with the same new features as listed above basicaly, but without the last-minute bugfixes before official release.

## [2.0.0](https://github.com/AliSoftware/OHHTTPStubs/releases/tag/2.0.0)

* Simplified API
  * removed instance methods, no more public `sharedInstance`: directly call class methods on the `OHHTTPStubs` class
  * The old and problematic `addRequestHandler:` method has been deprecated and should not be used anymore. Use `stubRequestsPassingTest:withStubResponse:` instead, which is more efficient
* Added API documentation in the headers
* Remove all internal uses of Apple's private APIs

> _Be careful: if you forgot to remove your use of `OHHTTPStubs` and your stubs from the binary you sent to the AppStore, your app would have been rejected by Apple before 2.0.0, as it was using private API (which was a way to make sure not to forget to remove them), but now it would be accepted silently. So don't forget to remove your stubs and `OHHTTPStubs` from your final binary!_

## [1.2.2](https://github.com/AliSoftware/OHHTTPStubs/tree/1.2.2)

* Fixed Deadlock introduced by 1.2.1

## [1.2.1](https://github.com/AliSoftware/OHHTTPStubs/tree/1.2.1)

* Improved thread-safety (#21)
* Stop sending messages to `NSURLProtoclClient` after `stopLoading`

> _This version is buggy as it introduced a deadlock when performing a request on the main thread. 1.2.2 fixes that issue._

## [1.2.0](https://github.com/AliSoftware/OHHTTPStubs/tree/1.2.0)

* Added support for "HTTP Message Data" stubs generated with `curl -is <someurl>` to replay them easily (#27). See the `README.md` for more info
* Added redirect support for 3xx response codes (#23)
* Dropped non-ARC support. Now `OHHTTPStubs` is to be compiled using ARC. _(This should not change anything as it is intended to be integrated using CocoaPods or compiled in a separate xcodeproj anyway)_

## [1.1.2](https://github.com/AliSoftware/OHHTTPStubs/tree/1.1.2)

Easier integration process:

* Use `#import <OHHTTPStubs/OHHTTPStubs.h>` again
* But adding the path to the library headers in your application project's `HEADER_SEARCH_PATH` is no longer needed!

## [1.1.1](https://github.com/AliSoftware/OHHTTPStubs/tree/1.1.1)

* Fixed crash when calling "setEnabled:" / "registerClass:" multiple times
* New integration process: we don't use the `PortableLibrary.xcconfig` anymore (as it generated problems for people using configuration with names other than "Debug" and "Release"). _(1)_

_You will now have to indicate the folder containing headers for `OHHTTPStubs` in your `HEADER_SEARCH_PATH` Build Settings, and we are back to `#import "OHHTTPStubs.h"` until a better solution is found_

> _(1) This modification for the integration process did only last for version 1.1.1. Version 1.1.2 restored `#import <OHHTTPStubs/OHHTTPStubs.h>` (but using a much better solution than the previous xcconfig used) and filling `HEADER_SEARCH_PATH` is no longer needed in further versions. See changelog for 1.1.2 above._

## [1.1.0](https://github.com/AliSoftware/OHHTTPStubs/tree/1.1.0)

* Added new API `shouldStubRequest:withRequestHandler:` to avoid useless building of stubbed response like `addRequestHandler:` does

## [1.0.6](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.6)

* Adding support for cookies (Set-Cookie headers)

## [1.0.5](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.5)

* Added Unit Tests
* Removed calls to the deprecated `dispatch_get_current_queue()` GCD function (was used with `dispatch_after` to add fake delay to stubbed responses)

## [1.0.4](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.4)

* Fixed #6 : "responseWithError:" released response object too soon

## [1.0.3](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.3)

* Fixed small compilation issues #4 (issue in sample code) & #5 (ARC invalid cast)

## [1.0.2](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.2)

* Embedded `OHHTTPStubs` in a neat static library for nicer integration in your Xcode4 workspaces.

## [1.0.1](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.1)

* Fix issue when used in a SenTestCase

## [1.0.0](https://github.com/AliSoftware/OHHTTPStubs/tree/1.0.0)

* Cleaning API, added `removeLastHandler` and `removeRequestHandler:` method.
* Now first stable API in this version.
* Example project now compatible with ARC and non-ARC environments

## [0.2.0](https://github.com/AliSoftware/OHHTTPStubs/tree/0.2.0)

* Added Example project
* Added ARC support
* Some fixes

## [0.1.0](https://github.com/AliSoftware/OHHTTPStubs/tree/0.1.0)

* Initial version