[MyST]: https://mystmd.org
[MyST Markdown]: https://mystmd.org/spec/
[Jupyter Notebook]: https://jupyter.org
[pre-commit]: https://pre-commit.com
[pagefind]: https://pagefind.app
[SemVer]: https://semver.org
[pdoc]: https://pdoc.dev/
[GitHub Actions]: https://github.com/features/actions
[PyTorch]: https://pytorch.org
[Scikit-Learn]: https://scikit-learn.org
[WebLLM]: https://webllm.mlc.ai/
[project-website-template]: https://github.com/AfterPythonOrg/project-website-template
[commitizen]: https://github.com/commitizen-tools/commitizen
[uv]: https://docs.astral.sh/uv/
[ruff]: https://docs.astral.sh/ruff/

# Overview

## What is `afterpython`
`afterpython` is a CLI tool that **abstracts away the complexity** of **content writing, website deployment, and package release/maintenance** by providing an opinionated set of modern tools — so you don’t have to spend time selecting or learning anything beyond the basics.

---
## Why use `afterpython`
- Write content directly in [MyST Markdown] or [Jupyter Notebook]
- Go from writing to **website deployment in minutes** — no need to learn any of the underlying tools
- Centralize all your content in a modern, **unified project website** — from documentation to blog posts
- Zero-config orchestration — Pre-configured modern tooling with sane defaults (see [](overview.md#tech-stack)), so you can start maintaining packages immediately **without learning each tool**
- 🚧 Export content as PDF — for example, combine all blog posts into a single PDF file
- 🚧 **⚡ Full-text search** across **ALL** your content in your website — docs, blogs, tutorials, everything
- 🚧 **🤖 Embedded AI Chatbot** that answers questions directly using an in-browser LLM — at no cost


---
## CLI Commands
```bash
# show all commands
ap --help

# or use terminal UI (TUI)
ap tui
```


---
## Tech Stack
- [MyST]
- [project-website-template]
- [pre-commit]
- [GitHub Actions]
- [pdoc]
- [commitizen]
- [uv]
- [ruff]
- [pagefind]
- [WebLLM]
<!-- - ty -->
<!-- - [pixi] -->
