//
//  ALTableView.swift
//  ALTableView
//
//  Created by lorenzo villarroel perez on 7/3/18.
//  Copyright © 2018 lorenzo villarroel perez. All rights reserved.
//

import UIKit

@objc public protocol ALTableViewProtocol: class {
    @objc optional func tableViewPullToRefresh()
    @objc optional func tableViewDidReachEnd()
    @objc optional func tableViewWillBeginDragging()
    @objc optional func tableViewWillEndDragging()
}

public class ALTableView: NSObject {

    //MARK: - Properties
    
    internal var sectionElements: Array<ALSectionElement>
    public weak var delegate: ALTableViewProtocol?
    public weak var viewController: UIViewController?
    public weak var tableView: UITableView?
    
    
    //MARK: - Initializers
    
    public init(sectionElements: Array<ALSectionElement>, viewController: UIViewController, tableView: UITableView) {
        
//        self.sectionManager = ALSectionManager(sectionElements: sectionElements)
        self.sectionElements = sectionElements
        self.viewController = viewController
        self.tableView = tableView
        super.init()
        self.sectionElements.forEach { (sectionElement: ALSectionElement) in
            sectionElement.delegate = self
        }
    }
    
    //MARK: - Public methods
    
    public func registerCell(nibName: String, reuseIdentifier: String) {
        let bundle = Bundle(for: type(of: self))
        let nib = UINib(nibName: nibName, bundle: bundle)
        self.tableView?.register(nib, forCellReuseIdentifier: reuseIdentifier)
    }
    
    public func registerHeaderFooter(nibName: String, reuseIdentifier: String) {
        let bundle = Bundle(for: type(of: self))
        let nib = UINib(nibName: nibName, bundle: bundle)
        self.tableView?.register(nib, forHeaderFooterViewReuseIdentifier: reuseIdentifier)
    }
    
    //MARK: - Private methods
    

}
















