## Beverly Hills

### Beverly Hills police use LRAD (sound cannon) at protest | June 26th

During a peaceful protest in Beverly Hills, police used the dispersal function of a LRAD (or sound cannon) on protesters. Footage is pointed at the ground, but audio shows individuals arguing. The LRAD's characteristic dispersal signal is used twice, each time without warning and for about 30 seconds. In addition, a photojournalist at the scene confirms the LRAD was used.

Due to its high risk of permanent injury, indiscriminate damage, and insufficient testing surrounding long-terms effects, the use of the LRAD dispersal function is considered to be police brutality in and of itself.

tags: lrad, protester

id: ca-beverlyhills-1

**Links**

* [1:34, 3:43](https://youtu.be/doQMq8Iwcjc?t=94)
* [Photojournalist's account](https://twitter.com/bfeinzimer/status/1277014331968782339)


### Officer shoves then pepper sprays protester | August 29th

A protester in the street argues with a police officer. The officer shoves the protester. The protester then says, "Don't fucking touch me." A second officer then pepper sprays the protester.

tags: protester, push, shove, pepper-spray, spray

id: ca-beverlyhills-2

**Links**

* https://twitter.com/SamBraslow/status/1299848702748536834


## Clayton

### Law enforcement gas teenagers at a park | June 2nd

Law enforcement disrupt teenagers' peaceful protest by throwing a gas grenade and almost starting a fire.

tags: tear-gas, tear-gas-canister, protester

id: ca-clayton-1

**Links**

* https://twitter.com/CorinneAllen20/status/1268000716884283393
* https://twitter.com/CliffBraun/status/1268038070667849728


## Compton

### Police beat person on the ground | May 31st

Two police offers have someone pinned to the ground and proceed to kneel on their head/neck, punch and kick them. A third officer joins them, also striking the person. The beating continues until a woman yells "why are y'all beating him?"

tags: beat, conceal, knee-on-neck, knee, punch, kick, threaten, inhumane-treatment, protester

id: ca-compton-1

**Links**

* https://www.reddit.com/r/PublicFreakout/comments/gvdl01/they_secluded_him_behind_a_wall_and_looked_around/
* https://laist.com/2020/06/10/los_angeles_deputies_compton_video_violent_arrest_dalvin_price.php
* https://ktla.com/news/local-news/violent-arrest-caught-on-camera-in-compton/
* [Street View](https://www.google.com/maps/@33.9038142,-118.2141026,3a,75y,255.55h,58.86t/data=!3m6!1e1!3m4!1sDJvjgZKDPB56Yw1A5Ovb6A!2e0!7i16384!8i8192)


### Sheriff's Deputies fire less-lethal rounds, tear gas at protesters | June 21st

Several thousand protesters marched on Father's Day from the site of Los Angeles Sheriff's Department shooting of Andrés Guardado on June 18 to the Los Angeles Sheriff's station in Compton. Andrés' father addressed the crowd in English and in Spanish. Deputies in riot gear pointed guns at protesters who chanted "put down your guns." A Sheriff Department helicopter flew overhead urging local residents who had joined the march to leave and go home so that they would not be tear-gassed when outside agitators were dealt with. Black protesters and protest leaders shared hugs with Guardado's family to show solidarity between the Black and Latino communities. As a few mothers of children slain by LAPD or LASD told their stories, a group of protesters split off to confront a second band of Deputies in riot gear. One protester yelled "F*** the police!" The deputies opened fire with non-lethal rounds, tear gas, and flash bangs.

Footage shows scattered protesters on pedestrian walkway with deputies firing tear gas around them. Additional footage shows protesters helping one another recover from the damage.

A journalist states they were tear-gassed while holding up their press badge in plain view.

Footage shows police and protesters separated by a barricade. Protesters shout at deputies to put their guns down. Without verbal warning, deputies fire on protesters.

In footage from a journalist, a protester wearing a U.S. military jacket shows off wounds to the head and abdomen from less-lethal rounds shot by deputies.

tags: tear-gas, projectile, shoot, rubber-bullet, protester, journalist

id: ca-compton-2

**Links**

* https://twitter.com/LATACO/status/1274874827786997761
* https://twitter.com/LATACO/status/1274881935664267264
* https://www.lataco.com/protest-andres-guardado/
* https://theintercept.com/2020/06/25/andres-guardado-los-angeles-police/
* https://twitter.com/josie_huang/status/1274859389921267713
* https://twitter.com/josie_huang/status/1274860188898430976
* https://www.reddit.com/r/PublicFreakout/comments/hdrvxc/police_in_la_open_fire_on_group_protesting_the/
* https://twitter.com/josie_huang/status/1274863117004988416


## Costa Mesa

### Law enforcement concealing badge | June 3rd

Law enforcement officer can be seen without a badge or name tag.

tags: hide-badge

id: ca-costa-mesa-1

**Links**

* https://old.reddit.com/r/orangecounty/comments/gvn42k/oc_sheriff_deputy_forgoing_his_name_badge_to_wear/


## Gustine

### Protesters attacked; police shake hands of attackers; tell protesters to wait in patrol cars | June 28th

About twenty anti-BLM protesters (holding a thin blue line flag and affiliated with California Valley Patriots (CVP)) were holding a rally in Gustine California (at the corner of Grove Avenue and 5th Street). A group of around 3 young people decided to hold an impromptu counter-protest, and parked across the street from the CVP protesters. CVP protesters came across the street and began shouting at the counter-protesters. Some time later, video shows one counter-protester on the ground, on the CVP proesters' side of the street, being beaten by CVP protesters. Another counter-protester is trying to intervene but being physically restrained by CVP protesters; a third is filming the incident as CVP protesters heckle her. Photos taken after the incident show at least two of the protesters badly beaten. Each side says the other started the altercation.

Police arrived shortly thereafter. They told the counter-protesters to wait in police cars (allegedly for their own protection); the counter-protesters say they were kept in police cars for nearly an hour. The CVP protesters were not put into police cars. One counter-protester says that counter-protesters tried to leave multiple times, but were told that they were not free to go. Police can be seen shaking the hand of one of the CVP protesters; counter-protesters claim police were somewhat dismissive of their allegations of assault against the CVP protesters. No arrests were made, but a report concerning the incident has been referred to the DA.

tags: abuse-of-power, protester

id: ca-gustine-1

**Links**

* [Video after the incident](https://twitter.com/stussycastro/status/1277345103862837249)
* [More video after the incident](https://twitter.com/stussycastro/status/1277347410855907328)
* [Video during the incident](https://twitter.com/greg_doucette/status/1279473878335655936)
* [Video during and after the incident](https://twitter.com/s_gardenhire/status/1278037063946792960)
* [Account from a counterprotester, with pictures of injuries](https://twitter.com/stussycastro/status/1279289483972628482)
* [Video of injuries; response (purportedly from CVP) in comments](https://www.facebook.com/jpvazquez2/videos/10158730583897268/)
* [Twitter feed with misc. other evidence](https://twitter.com/cecigam24)
* [Merced Sun-Star Coverage](https://www.mercedsunstar.com/news/local/article243914827.html)
* [West Side Connect Coverage](http://www.westsideconnect.com/community/groups-clash-in-gustine-altercation/article_ec25243e-bc97-11ea-8384-2b2fba8f80fb.html)
* [Yahoo News Coverage, with video before the incident](https://news.yahoo.com/police-investigate-altercation-between-groups-192038713.html)
* [Street view of the location, for reference](https://www.google.com/maps/@37.2535159,-120.998706,3a,60y,326.22h,85.89t/data=!3m6!1e1!3m4!1spuyVbnKo6ts2Zc-15NMVgg!2e0!7i13312!8i6656)


## Hollywood

### Law enforcement arrest people walking, you can hear on the radio “You should not be driving past anybody, stop and take somebody into custody”. | June 1st

Law enforcement arrest people walking, you can hear on the radio “You should not be driving past anybody, stop and take somebody into custody”, seemingly indiscriminately making arrests even as people are walking and it still looks to be light outside.

tags: arrest, threaten, inhumane-treatment, protester

id: ca-hollywood-1

**Links**

* https://twitter.com/AdoreDelano/status/1267688320735166465


### Police fire into a crowd of peaceful protesters at short range | June 2nd

Police are shown shoving a wall of peaceful protesters back from an intersection. Shortly after, officers begin to fire rubber bullets at the protesters from close range.

Footage does not indicate that any protesters were violent with any officer before the shooting began.

tags: shove, shoot, rubber-bullet, protester

id: ca-hollywood-2

**Links**

* https://www.youtube.com/watch?v=E_lO_IZVc4k&feature=youtu.be


## Huntington Beach

### Police fire at protesters on ground | June 1st

Protesters laid on ground and chanted. Police may have given dispersal order, but it is difficult to hear. Within 10 seconds of audible order, as protesters began standing, police fired projectiles at protesters. Police continued to fire off and on for at least one minute while protesters obeyed order to retreat.

tags: shoot, projectile, protester

id: ca-hungtingtonbeach-1

**Links**

* https://twitter.com/Ricardo_4715/status/1267334754119999488


## La Mesa

### Law enforcement shoot and throw tear gas at protesters | May 30th

Law enforcement stand off with protesters. Seemingly without provocation they start gassing and shooting at the protesters.

tags: tear-gas, projectile, shoot, protester

id: ca-lamesa-2

**Links**

* https://twitter.com/mamitbh/status/1267030342243778561


### Police shoot woman in the face with bean bag | May 31st

La Mesa PD shoot a woman in the face with a bean bag round.

tags: shoot, bean-bag, protester

id: ca-lamesa-1

**Links**

* [10:20](https://www.facebook.com/100010947670361/videos/1115087385532840)
* https://mobile.twitter.com/MarajYikes/status/1267030131563827200
* https://mobile.twitter.com/chadloder/status/1267290221562871809/photo/1
* [Body cam footage](https://www.reddit.com/r/Bad_Cop_No_Donut/comments/hw99zb/la_mesa_police_bodycam_of_the_protests_leslie/)


## Long Beach

### Reporter shot in neck by rubber bullet | May 31st

Photo shows large bruise the reporter got from a rubber bullet

tags: shoot, rubber-bullet, journalist

id: ca-longbeach-1

**Links**

* https://laist.com/2020/05/31/reporters_injured_protests_police.php
* https://twitter.com/AGuzmanLopez/status/1267269781805137920


### Woman struck in finger by projectile; police quell crowd with tear gas | June 1st

A crowd of protesters is chanting peacefully. A shot is fired offscreen and a woman screams. Footage shows the woman clutching her bleeding hand. The caption states her finger was "cut off." The crowd becomes agitated and police respond with tear gas.

tags: shoot, projectile, tear-gas, protester

id: ca-longbeach-2

**Links**

* https://www.tiktok.com/@scottmbark/video/6833632749052628230
* https://www.tiktok.com/@scottmbark/video/6833477841808657669
* https://twitter.com/hagh_sadegh/status/1276177550339907585


## Los Angeles

### Police use tear gas and riot rounds against protesters | May 29th

In footage taken by a bystander filming from her apartment, police advance down a street near a Downtown LA shopping center. Protesters retreat from police. Police continuously fire less-lethal rounds and chemical agents at protesters. Towards the end of the footage, a single firework is thrown at police by protesters.

tags: shoot, projectile, gas, protester

id: ca-losangeles-37

**Links**

* https://vimeo.com/424352612
* https://www.reddit.com/r/LosAngeles/comments/gti4eg/la_riots_5292020_police_line_advances_with_their/


### Protester shot in head | (believed to be) May 30th

Footage shows a protester sitting on the curb. They are bleeding from a wound to the head. Other protesters are attempting to treat them. Greg Doucette says that, per the journalist who submitted the video, police shot first, then gave the dispersal order.

Additional footage (link 3) shows other protesters with wounds from riot rounds.

tags: shoot, projectile, protester

id: ca-losangeles-30

**Links**

* https://twitter.com/greg_doucette/status/1268052132252602368
* https://twitter.com/andrewcurryla/status/1266906677820833793
* https://twitter.com/andrewcurryla/status/1266905784585052160
* [Street View](https://www.google.com/maps/@34.071154,-118.3583053,3a,60y,332.25h,94.01t/data=!3m6!1e1!3m4!1sBMaXVOuAN0T9coL-PijVSA!2e0!7i16384!8i8192)


### LAPD officer beats multiple protesters who are filming them during a protest in Beverley Hills | May 30th

An officer is seen beating an individual in a black jacket who was filming the officers. After being beat by a baton, the individual in the black jacket falls, and the officer continues to beat them. The eye-witness runs over to shield and protect the individual from the officer, and was beaten by the officer from behind while helping the fallen individual escape. At the end of the video, they are hit by a less-than-lethal projectile.

tags: beat, baton, projectile, protester

id: ca-losangeles-2

**Links**

* https://www.reddit.com/r/2020PoliceBrutality/comments/gxjk67/reposted_wo_officer_name_footage_of_lapd_at_last/


### Los Angeles law enforcement beat protesters with batons | May 30th

A line of Los Angeles law enforcement officers are attempting to get a peaceful crowd to move back, by shoving and using less-than-lethal ammunition (what looks like rubber bullets). While this is happening, a group of officers on one side beat several protesters with batons.

tags: beat, baton, shoot, rubber-bullet, protester

id: ca-losangeles-3

**Links**

* https://twitter.com/larryprincxpark/status/1266883515431505920
* https://twitter.com/kendrick38/status/1266997131430133761
* https://twitter.com/ElieTWMayniac/status/1266914242885754880
* https://www.instagram.com/p/CA1hQ8WHLp1/?igshid=x4dnp455q05t
* https://abc7.com/6231194/
* [LAPD Body cam footage](https://www.youtube.com/embed/hwZMZvlHEI4)


### ABC7 reporters are hit by tear gas | May 30th

ABC7 reporters are hit by a cloud of tear gas after protesters were gassed up the street by Los Angeles law enforcement, as reported in this news coverage.

tags: journalist, tear-gas

id: ca-losangeles-4

**Links**

* https://twitter.com/GMA/status/1266934049098121216


### Police beat protesters with batons | May 30th

In the video, protesters can be seen kneeling. Police swing batons at several protesters pressed against the side of a building.

tags: beat, baton, protester

id: ca-losangeles-5

**Links**

* https://www.reddit.com/r/2020PoliceBrutality/comments/gxjk67/reposted_wo_officer_name_footage_of_lapd_at_last/
* https://twitter.com/greg_doucette/status/1269101214706421760


### Los Angeles law enforcement beat protesters with batons while they have their hands up | May 30th

LAPD swinging batons and shooting projectiles at people simply standing there with their hands up.

tags: shoot, projectile, baton, protester

id: ca-losangeles-24

**Links**

* https://twitter.com/MattMcGorry/status/1267217360894562306
* https://twitter.com/greg_doucette/status/1267605209745887233
* https://twitter.com/greg_doucette/status/1267605209745887233


### Los Angeles law enforcement hit protester in the face with rubber bullet | May 30th

Activist and former White House and congressional staffer Deon Jones was hit in the face with a rubber bullet, fracturing two bones and nearly costing him one eye. Jones also alleges assorted other misconduct, reminiscent of incidents CA-LosAngeles-19, CA-LosAngeles32, and CA-SantaMonica-2

tags: shoot, projectile, protester

id: ca-losangeles-33

**Links**

* https://www.instagram.com/p/CA20QYJgaU6/
* https://www.instagram.com/p/CA1U9L9g_LD/
* https://laist.com/2020/06/11/uninsured_protesters_free_medical_aid_la_doctor.php
* https://losangeles.cbslocal.com/video/4578194-protester-deon-jones-describes-being-shot-with-rubber-bullet-by-police/
* https://www.foxla.com/news/i-felt-like-i-was-on-the-timeline-to-my-death-local-man-speaks-out-after-weekend-protest-ends-in-violence


### Riot police fire tear gas at peaceful protest, then use mace to corral protesters | May 30th

Footage shows a peaceful protest opposite a police line. Around 50 seconds, police fire tear gas behind protesters, trapping them between tear gas and the police line. Police tell protesters to move, but protesters insist they cannot leave because of the gas behind them. Around 1:40, police then pepper spray protesters, forcing them to retreat into the tear gas.

tags: tear-gas, mace, pepper-spray, spray, protester

id: ca-losangeles-34

**Links**

* https://www.reddit.com/r/2020PoliceBrutality/comments/h7q97a/using_mace_to_direct_protestors_through_teargas/


### Protester shot in the head by rubber bullet | May 30th

Images show a forehead injury received by a protester who had been hiding behind a dumpster.

This, among other incidents, has led LA Mayor Garcetti to instruct the LAPD to limit its use of rubber bullets.

tags: protester, shoot, rubber-bullet

id: ca-losangeles-35

**Links**

* https://i.redd.it/xpn4dnw342551.jpg
* https://www.reddit.com/r/LosAngeles/comments/h9e7i8/protesters_hid_from_lapd_shooting_rubber_bullets/
* https://www.latimes.com/california/story/2020-06-02/lapd-will-limit-use-of-rubber-bullets-on-protesters-garcetti-says


### Police fire at bystander filming from apartment | May 30th

Early in the morning on May 30th, a streamer is filming arrests from her apartment. She captures police pointing riot guns at another apartment in her building. Police fire one shot.

The man at whom police shot posted images of what appears to be a bean bag round and a broken window.

tags: bystander, shoot, bean-bag, property-destruction

id: ca-losangeles-36

**Links**

* [Stream; police target apartment at 0:30, shoot at 0:45](https://www.pscp.tv/w/1OwxWQXvOAjGQ)
* https://twitter.com/Sarah_Mojarad/status/1266633046591078400
* https://twitter.com/tracemeYo/status/1266633586322497538


### Police fire rubber bullets at small group of peaceful protesters | May 30th

Around 2AM on May 30th, a bystander films police from his apartment. Police fire projectiles - the filmer claims, based on a livestreamer's feed, that they are rubber bullets - at a small group of protesters from across an intersection. Police then take the intersection and march down the street, continuing to fire at protesters. At one point, another bystander asks the filmer who the police are shooting at. After the filmer points out the protesters, the other bystander states, "There are like 4 of them."

tags: protester, shoot, rubber-bullet

id: ca-losangeles-39

**Links**

* https://www.youtube.com/watch?v=UDLxeshoPnI
* https://www.reddit.com/r/LosAngeles/comments/gtjd0p/rubber_bullets_at_2am_dtla/


### Police fire rubber/pepper bullets at peaceful protesters | May 31st

The chants of "don't shoot" are very clear, and at around 0:20, the police opens fire on the peaceful protesters, scattering them.

tags: rubber-bullet, shoot, pepper-ball, protester

id: ca-losangeles-6

**Links**

* https://twitter.com/MatthewSantoro/status/1266916709304201216


### Police officer puts his knee on a protesters neck, is pulled off | May 31st

A police officer has his knee on a woman's neck, who already had 3 police officers on her. A different officer had to pull him away.

tags: knee, knee-on-neck, protester

id: ca-losangeles-7

**Links**

* https://www.reddit.com/r/PublicFreakout/comments/gturig/cop_has_his_knee_on_a_womans_neck_even_though/


### Police shoot rubber bullets at protesters | May 31st

After a driver forces their way through a crowd, the police start shooting rubber bullets at the people nearby.

tags: vehicle, rubber-bullet, protester

id: ca-losangeles-8

**Links**

* https://twitter.com/SUNDAYLOVERBOY/status/1266890947888996352


### Man shot in the head with deterrent rounds, is sent to hospital | May 31st

Man receives a shot to head from what looks to be a large deterrent round, he claims police shot him and he now has internal bleeding in the head. The LAPD has released body cam footage confirming he was shot in the head with a bean bag round while his hands were up. The LAPD says it is investigating the incident.

tags: projectile, shoot, protester, bean-bag

id: ca-losangeles-9

**Links**

* https://www.foxnews.com/media/marine-corps-veteran-shot-with-rubber-bullets-by-police-at-protest-i-had-my-hands-up
* https://www.latimes.com/california/story/2020-07-31/video-protester-had-hands-up-when-lapd-officer-shot
* https://www.youtube.com/watch?v=msNyNyw0JUM


### Police tackle and arrest protester, indiscriminately beat others with batons and shoot them with less lethals | May 31st

LAPD single out, tackle, and arrest an unarmed protester, then indiscriminately beat nearby protesters with batons and fire less lethals into the crowd.

tags: tackle, arrest, beat, shoot, baton, projectile, protester

id: ca-losangeles-11

**Links**

* https://twitter.com/greg_doucette/status/1267095100166987778
* https://twitter.com/sleepydayhana/status/1266930544811671552


### LAPD SUV drives into protesters, speeds away | May 31st

LAPD officer quickly drives his SUV into a crowd near Pershing Square, hitting what looks like two protesters, then throws it in reverse and speeds away

tags: vehicle, drive, protester

id: ca-losangeles-12

**Links**

* https://twitter.com/greg_doucette/status/1267277826354556928
* https://twitter.com/SophiaLeeHyun/status/1267216604388978689
* https://twitter.com/chadloder/status/1267314138428014594
* https://v.redd.it/9aiytt50g6251/DASH_1080#mp4
* https://old.reddit.com/r/PublicFreakout/comments/gu8mqp/police_drives_into_protestors_in_los_angeles/
* https://old.reddit.com/r/gifs/comments/gu8inv/la_cop_car_rams_protester_on_live_tv_chopper/
* https://www.tiktok.com/@youarelwl/video/6833135548887043334


### Los Angeles law enforcement shoot at a man on his own balcony | May 31st

Los Angeles police shoot at a man standing on his own balcony as he's filming, seemingly without provocation.

tags: shoot, projectile, bystander

id: ca-losangeles-13

**Links**

* https://twitter.com/cwellborn3/status/1267318753571811329


### Police shoot crowd of unarmed protesters with rubber bullets | (Believed to be) May 31st

A crowd of protesters chanting are shot with rubber bullets by a line of officers.

tags: shoot, rubber-bullet, protester

id: ca-losangeles-16

**Links**

* https://www.tiktok.com/@w17ard/video/6833082563913977093?lang=en


### Police beat kneeling protesters | (Believed to be) May 31st

Protesters kneeling in the street are approached by a line of police in riot gear. Police beat them with their shields, shove them, and appear to be arresting them when a riot round is fired and the camera moves.

tags: beat, shove, shield, arrest, protester

id: ca-losangeles-28

**Links**

* https://twitter.com/jkishore/status/1267216022634999808


### Police beat and pepper spray protesters | May 31st

Protester who repeatedly says he cannot see is shoved by an officer with a baton. The filmer yells at the officer that the protester is having trouble seeing. The officer pepper sprays the filmer.

tags: shove, strike, arrest, pepper-spray, spray, protester

id: ca-losangeles-45

**Links**

* https://twitter.com/r0seghoul/status/1268729811066740737
* https://www.tiktok.com/@laurenxorose/video/6833031215541521669


### Police shoot rubber bullets at two peaceful protesters | June 1st

Two peaceful protesters are standing in an empty street.  Dozens of police officers move forward and the protesters are shot by rubber bullets fired from officers.

tags: shoot, rubber-bullet, protester

id: ca-losangeles-15

**Links**

* [https://twitter.com/liveinochi/status/1267504585926557696](https://twitter.com/liveinochi/status/1267504585926557696)
* https://tikitoks.com/@jacksonmonroe/video/6833397689187716358


### LAPD destroy car to drag out occupants | (Believed to be) June 1st

LAPD seen smashing windows to drag passengers & driver out of a stopped car. The people inside said they were out protesting. So far LAPD hasn’t said why the stop was made.

tags: property-destruction, protester

id: ca-losangeles-25

**Links**

* https://twitter.com/GadiNBC/status/1268016449320177665


### Business owner flags down police for protection from looters; she is arrested | June 1st

Alleged looters and the owner and employees at a liquor store stood off outside store. A crowd had assembled to help the employees. Seeing a police cruiser passing by, one black employee flagged down the officers to request help.

The employee was arrested, along with her husband and others helping them, while the alleged looters ran off. The employee says she told police they had the wrong people and the criminals were getting away. She says the officer arresting her said, "I don't care about them." In addition, she says she was thrown against a wall when arrested.

tags: racial-profiling, arrest, shove, bystander

id: ca-losangeles-26

**Links**

* https://www.cbsnews.com/news/police-handcuff-good-samaritans-protect-store-looters/
* https://twitter.com/bubbaprog/status/1267641851215036416


### Police arrest protesters en masse and detain them in poor conditions | June 1st

Police arrested protesters en masse in downtown Los Angeles. Protesters hands were zip tied excessively tightly behind their backs and they were loaded onto buses and driven around the city. Some were taken to a temporary field jail at UCLA's Jackie Robinson stadium; UCLA claims it "failed to stop" LAPD from using the stadium as a "staging area," but was not told about the field jail until after the fact. Arestees were detained for long periods, still in excessively tight zip ties. Social distancing procedures were not observed.

Many protesters allege that conditions in the makeshift jails were poor -- detainees denied medical attention and permission to use the restroom, for instance -- and that they were released, many with dead phones, in unfamiliar places in the middle of the night with no way to get home. Two arrestees allege that police prevented them from leaving before the curfew went into effect, then arrested them for violating the curfew. One arrestee alleges that she was twice threatened with guns, that she was sexually assaulted by police, and that police mocked detainees having panic attacks. Police also allegedly arrested at least one homeless person (to whom the curfew was not supposed to apply) for a curfew violation.

A lawsuit has been filed in connection with these and other abuses by the National Lawyers' Guild; a separate lawsuit has been filed by one of the arrestees. (See also incidents ca-losangeles-32 (near-identical behavior the following day) and ca-santamonica-2 (similar behavior in Santa Monica).)

tags: abuse-of-power, arrest, homeless, inhumane-treatment, threaten, protester, zip-tie

id: ca-losangeles-19

**Links**

* [Complaint in NLG lawsuit](https://nlg-la.org/wp-content/uploads/sites/5/2020/06/AMENDED-COMPLAINT-ECF.pdf)
* [Allegations by protester Laura Montilla](https://www.instagram.com/p/CBBNXXkJs0a/?igshid=jgeposybda4a)
* [Relevant video](https://www.instagram.com/p/CBEr2emJRyJ/?igshid=oloj7lgtv81t)
* [Local news coverage mentioning the incident](https://abc7.com/protest-arrest-george-floyd-curfews/6234180/)
* [LA Times article mentioning both lawsuits](https://www.latimes.com/california/story/2020-06-22/complaints-lapd-abuses-mount-protest-lawsuit)
* [UCLA disapproves of use of Jackie Robinson stadium for a field jail](https://twitter.com/UCLA/status/1268039753015812096)
* [First response by UCLA professors, containing further allegations of misconduct by LAPD and LASD](https://twitter.com/ananyaUCLA/status/1267985147225231360)
* [Second response by UCLA professors](https://drive.google.com/file/d/157MdwMMCEebcUyesO9HMOYK9p21q3gpE/view)
* https://www.reddit.com/r/LosAngeles/comments/gxi8b2/how_is_noone_talking_about_this_women_from/
* https://abc7.com/uclas-jackie-robinson-stadium-used-as-field-jail-during-protests-/6229078/
* https://dailytrojan.com/2020/06/09/police-protocol-compromises-safety-of-student-protesters/
* https://www.tiktok.com/@manicxmel/video/6833292986214894853


### Police arrest protesters en masse and detain them in poor conditions | June 2nd

Police arrested protesters en masse near the home of LA mayor Eric Garcetti and in other parts of the city, zip tied their hands, and held them for extended periods without appropriate social distancing. At least one arrestee alleges that protesters were given explicit permission to remain past the curfew, then arrested for being out after curfew. Many arrestees say they were released in the middle of the night, without transportation home, in unfamiliar parts of the city.

Several arrestees describe police sexually harassing/assaulting them; other arrestees corroborate these accounts. Two arrestees report that processing of arrestees on their bus was delayed because they requested medical attention and other improvements in their conditions, which would constitute first-amendment-protected speech. Four other arrestees report that processing of arrestees on their bus was delayed because some arrestees removed unsafely-tight zip ties using a lighter. All arrestees who have shared accounts mention officers behaving in a mocking, condescending, and unprofessional manner. One arrestee recalls asking officers to turn on bodycams, and officers refusing to do so. If true, this would be a clear violation of LAPD policy. One arrestee allegedly should have been exempt from the curfew as they were returning home from work.

A lawsuit has been filed in connection with these and other abuses by the National Lawyers' Guild. (See also incidents ca-losangeles-19 (near-identical behavior the previous day) and ca-santamonica-2 (similar behavior in Santa Monica).)

tags: abuse-of-power, arrest, inhumane-treatment, lgbtq+, threaten, protester, zip-tie

id: ca-losangeles-32

**Links**

* [Complaint in NLG lawsuit](https://nlg-la.org/wp-content/uploads/sites/5/2020/06/AMENDED-COMPLAINT-ECF.pdf)
* [LATaco article, with audio](https://www.lataco.com/protest-arrests-horror-accounts/)
* [Allegations by protester Kayla Soren](https://ips-dc.org/police-kneeled-with-me-then-they-drew-their-guns/)
* [Allegations by protester Julia Dupuis](https://twitter.com/juliacdupuis/status/1268638919286861824)
* https://dailytrojan.com/2020/06/09/police-protocol-compromises-safety-of-student-protesters/


### LAPD officers fire at passers by out of the window of a patrol car | June 2nd

A group of people walk down the street as a police car approaches. The police car slows to a stop. The people turn and flee; an officer fires less-than-lethal ammunition out of the police car at them. The police car then continues on its way.

tags: shoot, pepper-ball, vehicle, drive, protester

id: ca-losangeles-1

**Links**

* https://twitter.com/balleralert/status/1268014113105555456
* https://twitter.com/theweirdingwayy/status/1268048483920928768
* https://twitter.com/EarvinD/status/1268087279458775040
* [abc7 report](https://abc7.com/deputies-shoot-pepper-balls-at-skateboarders-in-hollywood---video/6230652/)
* https://twitter.com/ItsjustmeD_/status/1268596982966218752


### Police shoot unarmed man in a wheelchair in the face | June 2nd

A man confined to a wheelchair is shot in the eye with a rubber bullet causing hemorrhaging from his eye. The man was unarmed and not protesting. Still photos show LAPD shooting less-than-lethal round at the man.

This incident took place at [426 South Broadway](https://www.google.com/maps/place/426+S+Broadway,+Los+Angeles,+CA+90013,+USA/@34.0487865,-118.2504023,19z)

tags: shoot, projectile, homeless, person-with-disability, bystander

id: ca-losangeles-17

**Links**

* https://www.reddit.com/r/LosAngeles/comments/gwzgn8/lapd_shoots_less_than_lethal_rounds_directly_at/
* https://www.dailynews.com/2020/06/03/dozens-arrested-in-downtown-los-angeles-tuesday-night-after-day-of-peaceful-protests/
* https://www.instagram.com/p/CBCiZXOlno4/
* https://twitter.com/Terminal_Redux/status/1268870944615026690
* https://abc7.com/society/homeless-man-hit-in-face-with-rubber-bullet-amid-la-protest-witnesses-say/6234476/


### Police fire into backs of protesters | June 2nd

A handful of protesters are seen walking away from police with their hands up. Police shoot at the protesters repeatedly for the duration of the video, about 40 seconds.

tags: shoot, projectile, protester

id: ca-losangeles-27

**Links**

* https://twitter.com/MattMcGorry/status/1268455032032133122


### Officer strikes peaceful crowd with baton, police then fire riot rounds | (Believed to be) June 2nd

Footage shows police near a group of protesters. One officer walks across the line of protesters, shoving many of them with his baton. Another officer then shoves an individual in a wheelchair. A third officer then grabs the wheelchair and pushes that individual away, back behind the police line.

Protesters become agitated and police begin firing riot rounds.

After 50 seconds, footage cuts to various other incidents.

tags: baton, strike, person-with-disability, shoot, shove, protester

id: ca-losangeles-31

**Links**

* https://twitter.com/ricci_sergienko/status/1267685230799777793


### Protester shows wound inflicted by less-lethal round | June 3rd

Footage from June 3rd shows a still of a wound on a protester's abdomen, inflicted by a less-lethal round. This is in the wake of a Mayoral ordinance for the LAPD to restrict their use of kinetic projectiles, particularly rubber bullets, and the injury is more consistent with direct, close range fire than proper use.

tags: protester, shoot, projectile

id: ca-losangeles-41

**Links**

* https://www.instagram.com/p/CBBpSZPnyke/


### Police fire projectiles at protesters and discharge teargas | June 5th

In Lakewood, police fire projectiles at protesters and discharge teargas.

tags: shoot, projectile, tear-gas, protester

id: ca-losangeles-20

**Links**

* https://abc7.com/lakewood-protest-tear-gas-black-lives-matter-fired-during/6235358/
* https://www.reddit.com/r/longbeach/comments/gyma59/lakewoods_peaceful_protest_ends_in_cops_shooting/ftb8mvt?utm_source=share&utm_medium=web2x
* https://www.reddit.com/r/longbeach/comments/gyma59/lakewoods_peaceful_protest_ends_in_cops_shooting/?utm_source=share&utm_medium=web2x


### Medic treats rubber bullet wound | June 8th

Footage from June 8th shows a medic treating a wound on the thigh of a female protester. The bullet broke the skin and has caused major bruising in a circle around the point of contact. This is in the wake of a Mayoral ordinance for the LAPD to restrict their use of kinetic projectiles, particularly rubber bullets, and the injury is more consistent with direct, close range fire than proper use.

tags: protester, shoot, rubber-bullet

id: ca-losangeles-42

**Links**

* https://www.instagram.com/p/CBKohCXnJld/


### Police make violent arrests, including ripping a protester out of his wheelchair and inducing an asthma attack | July 15th

Footage shows a scuffle as police arrest protesters. A protester in a wheelchair pushes police away from him. Police then knock him backwards out of his chair. The man attempts to pull himself away. Police close in. The protester grabs the officer's baton, but multiple officers restrain him and take his wheelchair away. One officer drags the chair and appears to knock a wheel loose, which then falls off after the officer scuffles with another protester. The protester who was in the wheelchair passively resists by locking his arms while police arrest him. Body cam footage released by the LAPD shows the man in the wheelchair striking an officer in the face during a physical altercation between the protester and the officer. Notably, the LAPD footage fails to show the lead up to the protester in the wheelchair slapping the officer.

Footage from instagram (second link, fourth in list) shows a man suffering an asthma attack after allegedly being struck in the neck with a baton. The last video in the instagram post appears to show the man on a gurney receiving medical attention. Other videos in the post show police shoving protesters with their hands and with batons. The poster also alleges that police held a woman in a chokehold.

Additional [footage](https://www.instagram.com/p/CCqPuekHCyg/) shows an officer striking a protester with a baton as the protester tries to help the man in the wheelchair.

Another [update](https://www.instagram.com/p/CCxPb28hRdN/) states all charges against him were dropped.\

tags: arrest, shove, strike, property-destruction, person-with-disability, baton

id: ca-losangeles-40

**Links**

* https://www.reddit.com/r/2020PoliceBrutality/comments/hrwunn/cops_assaulting_blm_protesters_including_a_man_in
* https://www.instagram.com/p/CCsYvr7n-Rg/
* https://www.latimes.com/california/story/2020-07-16/police-said-they-assaulted-an-officer-but-protesters-have-a-different-account
* https://www.nbcbayarea.com/news/national-international/lapd-releases-video-from-confrontation-with-protesters-in-downtown-la/2328794/?_osource=SocialFlowTwt_BAYBrand
* https://twitter.com/LAPDHQ/status/1284891644454596608
* https://www.instagram.com/p/CCqPuekHCyg/
* https://twitter.com/allykerans/status/1283563591900164096
* https://www.instagram.com/p/CCxPb28hRdN/


### Violent arrests after police initiate scuffle | July 25th

Footage shows police approaching a protester in the street and shoving her to the ground, knocking the phone out of her hand. As police continue to shove the protester, another runs into frame and knocks an officer to the ground. More police then join to arrest the two protesters. Two other protesters come into frame, yelling at police. One is thrown to the ground and knelt on by an officer to arrest her. The other is shoved over a vertical ring used to lock bikes. She is then repeatedly shoved as she tries to stand and approach her fellow protester on the ground.

tags: shove, arrest, strike, baton, property-destruction, protester

id: ca-losangeles-43

**Links**

* https://twitter.com/KTLA/status/1287241665703374848
* https://ktla.com/news/local-news/hundreds-of-protesters-gather-in-downtown-l-a-as-some-march-onto-101-freeway/


### Police officer fires riot gun at protester; other officers then fire as well | July 25th

LAPD stand-off with protesters during a Portland Solidarity march on 7/25. Officers advance towards protesters, who slowly back away. One officer fires a riot gun at protesters without apparent provocation and at a dangerously close range. Several officers then begin firing at protesters. Protesters throw small projectiles in response.

tags: shoot, projectile, protester

id: ca-losangeles-44

**Links**

* https://www.reddit.com/r/2020PoliceBrutality/comments/hzol2y/lapd_standoff_with_protesters_during_a_portland/


### Woman recording peaceful protests shot by less lethals | July 25th

A woman who was recording protests was shot with less lethals by LAPD officers. She states that bystanders and peaceful protesters were struck.

tags: shoot, projectile, protester

id: ca-losangeles-47

**Links**

* https://twitter.com/Jas20274433/status/1288141598698610689
* https://twitter.com/Jas20274433/status/1288141708484464641


### Man filming arrests is thrown to the ground | July 31st

A man filming protesters being arrested is told by officers conflicting places to stand. One officer then shoves him to the ground and tells him to back up.

tags: shove, protester, push

id: ca-losangeles-46

**Links**

* https://twitter.com/chadloder/status/1289385606099812352
* https://twitter.com/chadloder/status/1289395335211540481


### Officers shove and shoot Black Lives Matter protesters | August 21st

At a dual protest between pro-Trump and Black Lives Matter protesters, BLM protesters entered the street and were confronted by police. This occurred after a member of the pro-Trump protest pepper sprayed BLM protesters.

Officers shoved protesters with batons, then an officer with a riot gun fired into the crowd from short distance. Justification is unclear. Regardless, the distance from which the officer fired the gun is against protocols.

tags: protester, push, shove, baton, shoot, projectile

id: ca-losangeles-48

**Links**

* https://twitter.com/abc7chriscristi/status/1297041164902649858
* https://twitter.com/desertborder/status/1296970764701192192
* https://twitter.com/teegeez123/status/1297036568352272384
* https://twitter.com/WallofVets/status/1297061991802998785
* https://twitter.com/WallofVets/status/1297351314653896704


### LA Sheriffs tear gas protesters | August 25th

LA Sheriffs surround protesters and begin firing tear gas and impact munitions without warning. Protesters do not appear to be inciting violence or agitating in any way.

tags: protester, shoot, projectile, tear-gas

id: ca-losangeles-49

**Links**

* https://www.instagram.com/tv/CEV-cnggrvj/


### Officers trap protesters under bridge and shoot them | August 26th

Protesters in LA were trapped by police in a tunnel. Police demanded that protesters relinquish their shields. As protesters began to do so, police fired on the crowd. Police then held protesters at the scene, allegedly allowing them to leave in small groups after being frisked.

tags: protester, shoot, projectile, abuse-of-power

id: ca-losangeles-50

**Links**

* https://twitter.com/cogeian/status/1298864638411431938
* https://twitter.com/cogeian/status/1298867138547994629
* https://twitter.com/DjMontecito/status/1298868748074405888
* https://twitter.com/teegeez123/status/1299006192526585857
* https://twitter.com/missippigurl/status/1299061628051156992
* https://www.instagram.com/p/CEY5r64AEip/


### LA Sheriffs fire impact munitions at protesters | September 5th

LA Sheriffs throw stun grenades and fire impact munitions at protesters on the sidewalk. The LASD allegedly never declared an unlawful assembly.

tags: protester, shoot, projectile, stun-grenade, foam-bullet, pepper-ball

id: ca-losangeles-51

**Links**

* https://twitter.com/PplsCityCouncil/status/1302457503125389313
* https://twitter.com/PplsCityCouncil/status/1302452861876408320
* https://twitter.com/cogeian/status/1302452302339387392
* https://twitter.com/cogeian/status/1302451901221335040
* https://twitter.com/bfeinzimer/status/1302453111152279552
* https://twitter.com/waterspider__/status/1302452882562662400
* https://twitter.com/waterspider__/status/1302454947317907456
* https://clips.twitch.tv/GeniusPrettyPartridgeHeyGirl


### LA Sheriffs deploy less lethals at peaceful protesters | September 7th

Police fire impact munitions (believed to be pepper balls), stun grenades and tear gas at protesters without provocation. Police then continue to fire on protesters as they retreat.

At least one journalist was shot during the incident. The last link shows an image of a protesters injuries after being hit with the less lethal munitions.

tags: pepper-ball, stun-grenade, tear-gas, protester, journalist, shoot, projectile

id: ca-losangeles-52

**Links**

* https://twitter.com/desertborder/status/1303197878169382912
* https://twitter.com/desertborder/status/1303199667971215362
* https://twitter.com/desertborder/status/1303199962432299008
* https://twitter.com/VenturaReport/status/1303206541240066048
* https://twitter.com/VenturaReport/status/1303205807589224448
* https://twitter.com/VenturaReport/status/1303208091673010176
* https://twitter.com/VenturaReport/status/1303205326615789568
* https://twitter.com/VenturaReport/status/1303211258376716288
* https://twitter.com/VenturaReport/status/1303389344749682688
* https://twitter.com/itsa_talia/status/1303396046840700928
* https://twitter.com/desertborder/status/1303210505658494977
* https://twitter.com/jintakhan/status/1303266851502223360
* https://twitter.com/jintakhan/status/1303422157578412033


### Police deploy tear gas and impact munitions against protesters | September 8th

Protesters gathered in the street in Los Angeles on September 8th. Police approached in a line, flanking an armored vehicle. Police then charged protesters without warning and fired impact munitions (both rubber bullets and pepper balls) and stun grenades for several minutes. Several bystander cars were struck by munitions.

tags: protester, bystander, property-destruction, shoot, projectile, pepper-ball, rubber-bullet, stun-grenade

id: ca-losangeles-53

**Links**

* https://twitter.com/SamBraslow/status/1303563878039658497
* https://twitter.com/chrismatography/status/1303567876360527872
* https://twitter.com/bfeinzimer/status/1303573309041201157
* [3:20](https://www.instagram.com/p/CE5pz8Tnlir/)
* [36:00-42:00; filmer then shows recovered rubber bullet at 55:00](https://www.instagram.com/p/CE5rJzPpZKP/)


### Livestreamer tackled off bike and arrested | September 8th

An independent journalist, AlienAlphabet, was livestreaming as they biked away from a protest. The livestream shows the journalist knocked off their bike. Police yell for them to get on the ground. Police then arrest the journalist.

tags: journalist, tackle, arrest

id: ca-losangeles-54

**Links**

* https://twitter.com/ClippingFor/status/1303586283504058368
* [Livestream; 34:00](https://www.youtube.com/watch?v=t3iFkuOWpYY)


### Reporter arrested during protests | September 12th

Reporter Josie Huang was covering the shooting of 2 LASD officers and a small ensuing protest in LA when she was arrested for "obstruction of justice;" Huang states she was simply documenting an arrest. In addition, officers claim she was not properly identified, but footage shows a LASD-issued press pass around her neck.

Huang was released early on September 13th. Footage Huang uploaded following her release shows officers shoving her and knocking her phone to the ground. Officers then step on and kick the phone while Huang can be heard stating that officers are hurting her.

tags: journalist, arrest, property-destruction

id: ca-losangeles-55

**Links**

* https://twitter.com/TheChalkOutline/status/1305030195066236928
* https://twitter.com/StoltzeFrankly/status/1305041338803523586
* https://twitter.com/busblog/status/1305079558861848576
* https://laist.com/latest/post/20200913/80222d039da6e2435bed1e10df36e367457cd4af
* https://twitter.com/Terrence_STR/status/1305142121767276544
* https://twitter.com/josie_huang/status/1305111565285253122
* https://twitter.com/josie_huang/status/1305265081144410112
* https://twitter.com/josie_huang/status/1305265782352310273


### Police charge protesters without warning, make violent arrest | September 13th

Footage shows a standoff between protesters and police. Police tape divides the two groups. Additional officers approach the line, then charge across at protesters without warning. One protester, Sean, is seen thrown to the ground and arrested with his hands held behind his back. Sean labels himself a "protest observer;" while not officially press, he focuses on filming protests, rather than participating. He can be heard screaming in pain during the arrest. He allegedly waited 20 minutes in handcuffs for EMS to arrive.

tags: protester, arrest

id: ca-losangeles-56

**Links**

* [7:40](https://streamable.com/0z69lw#)
* https://twitter.com/itsa_talia/status/1305336981069594624
* https://www.reddit.com/r/2020PoliceBrutality/comments/isqbcw/an_unarmed_member_of_the_press_was_dragged/
* https://www.tiktok.com/@sunflower_haze_/video/6872014053036854533
* https://www.tiktok.com/@sunflower_haze_/video/6872019962655984902


## Norco

### Woman struck by white supremacist while police look on | June 29th

A man wearing a shirt with two SS lightning bolts harasses a filming BLM protester. He and another counter-protester call her a bitch repeatedly, then slaps the phone out of her hand. Police state they did not see the incident, although the link shows clearly that an officer is standing next to them. The officer is joined by another. They stand between the groups of protesters and tell the BLM protesters to keep moving. The woman says she needs to find her phone and the officer says they have to come back for it later.

In addition, the second link shows this individual having assaulted protesters on multiple occasions without repercussion.

tags: abuse-of-power, protester

id: ca-norco-1

**Links**

* https://twitter.com/le_maria21/status/1277801107033481216
* https://twitter.com/le_maria21/status/1277800993984413696


## Oakland

### Officer runs down protesters with police cruiser | (believed to be) May 30th

A police cruiser in Oakland was seen driving erratically and chasing down protesters in the street, hitting several of them.

tags: vehicle, drive, protester

id: ca-oakland-1

**Links**

* https://www.reddit.com/r/PublicFreakout/comments/gttdkj/cop_driving_into_crowds_of_protestors/
* https://tuckbot.tv/#/watch/gttdkj


### Oakland law enforcement shoot a reporter | May 31st

A reporter films a street with a few protesters walking around.  In the distance, a line of Oakland law enforcement is standing. The law enforcement officers shoot the reporter.

tags: journalist, shoot

id: ca-oakland-2

**Links**

* https://twitter.com/SarahBelleLin/status/1266980899301683200


### Water bottle tossed at police; police retaliate against crowd | June 2nd

Footage shows a water bottle lobbed towards police. Police then retaliate against the entire crowd, firing tear gas indiscriminately.

tags: tear-gas, protester

id: ca-oakland-3

**Links**

* https://twitter.com/byjacobward/status/1267695808784199680
* https://twitter.com/greg_doucette/status/1270490060287344642


### Protester singled out, chased and arrested | July 26th

Police gather around a protester standing on a pedestrian median. He is singled out by police. He is threatened with arrest, then flees. A hissing sound can be heard prior to his flight, which may be pepper spray. Officers then chase, tackle, and arrest him. Motive for the arrest is unclear.

tags: protester, arrest, tackle

id: ca-oakland-4

**Links**

* https://twitter.com/SarahBelleLin/status/1287321616636997632


## Riverside

### Law enforcement break a car window for no apparent reason | June 2nd

A line of law enforcement officers are walking down the street.  When they approach a parked vehicle, law enforcement break the vehicle's window for no apparent reason.

tags: property-destruction

id: ca-riverside-1

**Links**

* https://old.reddit.com/r/PublicFreakout/comments/gv2lku/news_chopper_pans_out_as_riverside_county_sheriff/


## Sacramento

### Man severely injured by tear gas and impact munitions | May 30th

A man who said he was bringing snacks to protesters says he was caught in police fire and severely injured. He states he a tear gas canister exploded in his face and he was shot with impact munitions. He required a titanium plate in his skull to repair the damage caused by a tear gas canister striking him in the head. He also requires surgery to repair his jaw. He is part of a lawsuit against the city, along with lawyer Danny Garza.

tags: shoot, projectile, protester, tear-gas

id: ca-sacramento-6

**Links**

* https://www.kcra.com/article/sacramento-resident-needs-surgery-head-injuries-george-floyd-protest/32801846


### Police shoot protester in the head | May 30th

A crowd of protesters demonstrating in front of a line of police officers was fired upon, after which a man fell to the ground. He was carried away and seen to be bleeding profusely.

tags: shoot, projectile, protester

id: ca-sacramento-1

**Links**

* https://youtu.be/pRmBO34aXME
* https://twitter.com/mynameschazz/status/1266978442722947072


### Sacramento law enforcement shoot protesters and then announce their assembly is unlawful | May 31st

Sacramento law enforcement shoot protesters and then announce their assembly is unlawful. A legal observer, Danny Garza, was shot in the eye during the incident. He and several other protesters have brought a lawsuit against the city of Sacramento.

tags: shoot, projectile, protester, legal-observer

id: ca-sacramento-2

**Links**

* https://www.facebook.com/danny.garza.167/videos/10222535335080905/
* https://www.abc10.com/article/news/local/sacramento/sacramento-police-sued-for-exessive-force-allegation/103-3ae82150-782c-4606-a5e5-6d25bb10bb00?fbclid=IwAR0ru-oqE9MEgTpBdSE81XM19qxsxngBjtjgavg0WPWG9-HnB3y6ft0DhGE
* https://www.docdroid.net/veyoGHL/phansopha-v-city-of-sacramento-complaint-pd


### Police fire tear gas and flashbangs without apparent cause | May 31st

Footage shows protesters facing off against police. Without warning, police fire tear gas and flashbangs, causing protesters to flee.

tags: stun-grenade, tear-gas, protester

id: ca-sacramento-5

**Links**

* https://www.reddit.com/r/Sacramento/comments/gul234/last_night_sacramento_protesters_for_george_floyd/
* https://www.youtube.com/watch?v=TSshaAoTuUw


### Police choke man and push woman filming event to the ground | June 1st

Two to three police officers choke a black man on the ground. The woman documenting this on video is then pushed away/over.

tags: choke, shove, push, threaten, baton, protester

id: ca-sacramento-3

**Links**

* [From perspective of woman pushed, where we see man being choked](https://twitter.com/greg_doucette/status/1268334584443342850)
* [From a different angle, where we see filming woman pushed down](https://twitter.com/reereeisme65/status/1267378345894789125)
* [Additional angle](https://www.tiktok.com/@sameoldmatt/video/6833452428025679109)


## San Diego

### Police kettle and fire on fleeing protesters | May 31st

Police block off sidewalks to kettle protesters. Tear gas canisters can be heard as the police line advances. An officer fires on several fleeing protesters at close range. Protesters are shoved by authorities as they plead for officers to stop firing on them.

tags: tear-gas, tear-gas-canister, shoot, protester

id: ca-sandiego-2

**Links**

* [Youtube link](https://www.youtube.com/watch?v=6uNySPSwhAI&feature=youtu.be)
* [Youtube mirror](https://www.youtube.com/watch?v=dHji5Xrcbo8&feature=youtu.be)
* [/r/2020PoliceBrutality thread where date of protest is confirmed by poster](https://www.reddit.com/r/2020PoliceBrutality/comments/gynpd8/police_block_off_sidewalks_and_start_shooting_at/)


### Woman shot in the face with a rubber bullet | May 31st

Footage of a woman bleeding profusely from the head. Poster says SDPB were using rubber bullets. The woman was taken to the hospital and was in stable condition as of May 31st

tags: shoot, rubber-bullet, protester

id: ca-sandiego-3

**Links**

* https://twitter.com/chadloder/status/1267290221562871809
* https://twitter.com/MarajYikes/status/1267030131563827200


### Police fire on dancing protesters | May 31st

Footage shows protesters playing music and dancing. Without warning, shots can be heard and tear gas is seen. Protesters then flee.

tags: tear-gas, shoot, projectile, protester

id: ca-sandiego-4

**Links**

* https://twitter.com/mariahalize3/status/1267225330093191168


### Student journalist shot and tear gassed | May 31st

A student journalist attended protests in San Diego on May 31st. San Diego Police declared an unlawful assembly, then began firing tear gas and pepper balls at protesters. The journalist was standing on the sidewalk filming, when tear gas drifted into his eyes. He then turned for cover and was shot with pepper balls.

tags: journalist, tear-gas, shoot, pepper-ball

id: ca-sandiego-5

**Links**

* https://pressfreedomtracker.us/all-incidents/san-diego-student-journalist-hit-tear-gas-projectiles-while-covering-protest/
* https://twitter.com/plutotoplato/status/1267224695239131137


### Police abduct woman in unmarked van | June 4th

A group of police officers carry a woman into an unmarked van. They state they will shoot anybody that follows the van.

tags: threaten, arrest, hide-badge, inhumane-treatment, protester

id: ca-sandiego-1

**Links**

* [From perspective of women watching the abducted being pulled into the car and driving away](https://twitter.com/greg_doucette/status/1269009907367493634)


## San Francisco

### San Francisco law enforcement shove man off the sidewalk onto the ground | May 31st

A police SUV is attempting to drive through a crowd.  A law enforcement officer shoves the man from behind off the sidewalk onto the ground in front of the vehicle.

tags: drive, shove, protester

id: ca-sanfrancisco-1

**Links**

* https://twitter.com/caseylc9/status/1267285516262596608


## San Jose

### Police shoot a projectile at a protester | May 29th

A police officer shoots a projectile at a protester for yelling out profanities. The same officer is seen excited about the protests yelling "let's get this motherfucker".

tags: shoot, projectile, threaten, protester

id: ca-sanjose-1

**Links**

* https://twitter.com/junkieanteater/status/1266603252839141377
* https://www.reddit.com/r/PublicFreakout/comments/gtksgq/cop_decides_to_shoot_at_protestor_who_hurt_his/
* https://www.reddit.com/r/PublicFreakout/comments/gtg2cb/cop_waits_in_excitement_like_its_a_game/
* https://twitter.com/bowiezamudio/status/1266598285206106113
* https://twitter.com/kakimeows/status/1266982771005616128
* https://twitter.com/venomwithinher/status/1266826205833031680


### Officer puts knee on neck of protester | May 29th

A police officer shoves aside another officer restraining a suspect so he can put his knee on the suspect's neck.

tags: knee-on-neck, arrest, protester

id: ca-sanjose-3

**Links**

* https://twitter.com/DeadByDawn101/status/1268825100385521665


### Police fire on community activist | May 29th

A protester and community activist, known for work anti-bias and community building work with the San Jose PD, is fired upon by police. Though he has his hands in the air, police fire on him numerous times, striking him once in the groin. Later reports state the man suffered a ruptured testicle.

tags: shoot, rubber-bullet, protester

id: ca-sanjose-2

**Links**

* https://twitter.com/greg_doucette/status/1269267786792144898
* https://abc7news.com/man-who-trains-san-jose-police-about-bias-severely-injured-by-riot-gun-during-protest/6234212/
* https://www.latimes.com/california/story/2020-06-06/community-organizer-shot-by-rubber-bullet-during-protest
* https://www.fox23.com/news/trending/george-floyd-protests-san-jose-police-fire-rubber-bullets-own-bias-trainer-rupture-his-testicle/K5HUBNAHTJERPBKA2CVC2B5LRU/


### Police knocks phone out of protester's hand; riot control measures follow | May 29th

A protester can be seen filming SJPD officers' badge numbers. One officer swats the phone out of the protester's hand. The camera angle shifts, but the protester appears to retaliate by punching the officer.

The riot police retaliate against the entire protest, firing rubber bullets and tear gas.

tags: shove, property-destruction, shoot, rubber-bullet, tear-gas, protester

id: ca-sanjose-4

**Links**

* https://twitter.com/itssdelilahh/status/1266575145537163269


### Man struck by rubber bullet and explosive device | May 29th

A protester filming receives water bottles from a car and begins to distribute them. Without warning, police fire into the crowd. The man is hit and is helped by a second protester. While the second protester is attempting to help, a canister explodes at the man's feet.

tags: rubber-bullet, explosive, shoot, projectile, protester

id: ca-sanjose-5

**Links**

* https://www.youtube.com/watch?v=89mUHzu3480


### Woman shot in the head with foam round | May 29th

A woman at a protest on May 29th was shot in the temple by a foam bullet. She stated in an interview, "she heard no audible verbal warning from SJPD about their intent to use riot guns or physical force." The SJPD stated several verbal warnings were given. The woman stated she was assisted by a paramedic, given an ice pack, and told to see a doctor.

tags: protester, shoot, foam-bullet

id: ca-sanjose-8

**Links**

* https://abc7news.com/video/embed/?pid=6326456
* https://abc7news.com/san-jose-police-department-sjpd-lawsuit-george-floyd-protest-civil-rights/6325926/
* https://www.sanjoseinside.com/news/hundreds-of-rubber-bullets-later-san-jose-starts-to-reckon-with-human-toll-of-tactics/
* https://www.sanjoseinside.com/wp-content/uploads/2020/06/Breanna9-768x1024.jpg
* https://www.sanjoseinside.com/wp-content/uploads/2020/06/Breanna2-768x1024.jpg


### Man struck in face by police, severely injured | May 29th

A man approaches police, filming with his camera. He is struck in the face by an officer with a baton. He then throws a punch back and is wrestled to the ground by several officers and arrested. He was taken to a hospital for arrestees and diagnosed with a shattered kneecap. He says that the recovery is expected to take months.

tags: strike, beat, arrest, baton, protester

id: ca-sanjose-9

**Links**

* https://twitter.com/abc7newsbayarea/status/1266527253862719488
* https://www.sanjoseinside.com/news/hundreds-of-rubber-bullets-later-san-jose-starts-to-reckon-with-human-toll-of-tactics/
* https://www.sanjoseinside.com/wp-content/uploads/2020/06/48416200_1590892268340884_r.jpeg
* https://www.sanjoseinside.com/wp-content/uploads/2020/06/DSC08021.jpg


### Police shoot at woman in apartment | May 30th

A woman was yelling at police during a May 30th protest from her apartment window. Shortly after starting a recording on her cell phone, police fired projectiles at the woman's apartment. She recovered 13 projectiles, including rubber bullets and pepper balls. Several of her windows were damaged.

A police spokesperson stated that someone in the building was throwing glass bottles at police. The woman states she was not throwing anything.

The woman has retained a lawyer. A team from the mayor's office helped repair the woman's apartment the day after the incident.

tags: bystander, shoot, rubber-bullet, pepper-ball, property-destruction

id: ca-sanjose-10

**Links**

* https://abc7news.com/video/embed/?pid=6260831
* https://abc7news.com/new-excessive-force-complaint-against-sjpd/6260863/


### Police strike man with motorcycle | May 31st

A man is seen running across a street, chased by several officers. An officer on a motorcycle strikes him and he is arrested.

Officers allege he was seen attempting to break into a bank after curfew.

tags: vehicle, arrest, protester

id: ca-sanjose-6

**Links**

* https://www.mercurynews.com/2020/06/03/video-of-police-motorcycle-hitting-man-brings-more-scrutiny-to-sjpd/


### Police shoot small group of unarmed protesters | June 3rd

Police give orders to disperse and subsequently to lay on the ground. Protesters attempt to flee and first-person footage states a protester was tripped and shot at short range.

Additional footage shows numerous officers corralling protesters into a small area before firing

tags: shoot, protester

id: ca-sanjose-7

**Links**

* https://twitter.com/ex_Tesla/status/1268341102211297280
* https://twitter.com/greg_doucette/status/1269985578474524673


## San Luis Obispo

### Law enforcement fire on crowd with their arms up chanting | June 1st

Protesters standing with their arms raised are chanting "This is what democracy looks like".  Law enforcement fire on the crowd and gas can be seen.

tags: shoot, tear-gas, protester

id: ca-sanluisobispo-1

**Links**

* https://twitter.com/ma7dz/status/1267697838244298752


## Santa Ana

### Police open fire on protesters | May 31st

The individual recording the video is trying his best to save his fellow protester, however his cries are upon deaf ears, the police continue to shoot at them around 0:16

tags: shoot, projectile, protester

id: ca-santaana-1

**Links**

* https://twitter.com/YourAnonCentral/status/1266991237355069442


## Santa Monica

### Police fire pepper bullets into apartment | May 31st

Live on TV, police fire multiple pepper bullets at a second-story apartment window from the street below.

tags: shoot, pepper-ball, protester

id: ca-santamonica-1

**Links**

* https://twitter.com/GIFsZP/status/1267241803750813703


### Police arrest protesters en masse, confine them for long periods, and improperly zip tie them | May 31st

On May 31st, police arrested numerous protesters for curfew violations. These protesters were zip tied and held for long periods, in tight quarters which did not permit social distancing, then released late at night with no way to get home. At least one detainee alleges that detainees were denied medical care and permission to use the restroom.

Zip ties were put on too tight. Police attempted to remove zip ties with a long knife (which is not the appropriate tool). This led to multiple protesters being injured, including one who required 21 stitches; it seems unlikely that the knife was appropriately sterilized between uses, raising the possibility of bloodborne pathogen transmission.

(See also incidents ca-losangeles-19 and ca-losangeles-32 (similar behavior in Los Angeles). Note that the final link incorrectly states that the incident it describes was perpetrated by LAPD; in fact, as several commenters pointed out, it was perpetrated by Santa Monica PD, though there are allegations of similar conduct by the LAPD.)

tags: abuse-of-power, arrest, inhumane-treatment, protester, zip-tie

id: ca-santamonica-2

**Links**

* [Picture of one detainee's hand with stitches; description of what happened](https://www.instagram.com/p/CA88dZmFPPT/)
* [Another detainee, apparently being injured as her zip ties are removed](https://www.instagram.com/p/CBB2mn6A8pi/)
* [Images and video of police removing zip ties with a knife, cutting protesters](https://www.instagram.com/p/CBEFX7wlWFa/)
* [Video of detainees zip tied on a bus. Also includes account of what happened.](https://www.instagram.com/p/CA53NtTAsGr/)
* [News article, mentioning incident with comment from Santa Monica police](https://abc7.com/protest-arrest-george-floyd-curfews/6234180/)
* [Example of the appropriate tool to cut zip ties](https://www.lawmens.com/safety-cutter-for-disposable-restraints/?gclid=Cj0KCQjwudb3BRC9ARIsAEa-vUtIsFPg0gSDXLSKkG__DPSoK1K2bQ5d6PZBn-rO3U5rdBEMotdtR18aAjYgEALw_wcB)
* https://www.reddit.com/r/LosAngeles/comments/gy3e3r/the_lapd_has_been_slicing_into_protesters_hands/?utm_source=share&utm_medium=web2x


### Reporter shot with rubber bullets | May 31st

A reporter for Primer Impacto was livestreaming a protest on Facebook. Around 12 minutes into the video, shots are fired without warning and the woman screams. She says to a man on her crew (in Spanish), "They just hit me, Patricio, in the leg."

tags: journalist, shoot, rubber-bullet

id: ca-santamonica-3

**Links**

* https://pressfreedomtracker.us/all-incidents/primer-impacto-reporter-injured-rubber-bullet-during-protests-santa-monica/
* [12:00](https://www.facebook.com/PrimerImpactoUnivision/videos/2555589674702920/)


## Vallejo

### Police fatally shoot unarmed 22 year old | June 1st

Police in northern California fatally shot an unarmed 22-year-old who was on his knees with his hands up outside a Walgreens store while responding to a call of alleged looting, officials said... An officer in the city of Vallejo was inside his car when he shot Sean Monterrosa on Monday night amid local and national protests against police brutality. Police said an officer mistakenly believed Monterrosa had a gun, but later determined he had a hammer in his pocket... 'When confronted by the police, he dropped to his knees and surrendered, and they fired at him,' said Melissa Nold, a Vallejo civil rights attorney representing Monterrosa’s family.

Six officers fired 55 bullets in 3.5 seconds; police investigation determined this use of force 'reasonable.'

Vallejo PD has posted composite video containing body cam footage, radio chatter with Dispatch and prior footage of Walgreen's security cameras being destroyed. This footage shows a car with alleged looters peeling out of the Walgreens as police arrive; this car strikes an unmarked police vehicle and continues. Police open the doors of their unmarked van and fire on Monterrosa immediately and without warning. They state that they believed Monterrosa was armed, thought it turned out to be only a hammer.

tags: shoot, live-round, death

id: ca-vallejo-1

**Links**

* https://www.theguardian.com/us-news/2020/jun/04/vallejo-police-kill-unarmed-man-california
* https://www.theguardian.com/us-news/2019/jun/12/willie-mccoy-shooting-vallejo-police-55-shots
* [Footage provided by Vallejo PD; CW: death](https://vimeo.com/436510158)


## Walnut Creek

### Armored law enforcement vehicle threatens protesters, deploys tear gas on highway | June 1st

In this video, an armored law enforcement vehicle tells protesters blocking a highway to disperse over megaphone. It sounds like the operator is saying "if you do not move, you will be dead," but video later released by the police department seems to show that the operator instead said "if you do not move, you will be gassed." The protesters do not move; the officers deploy tear gas, coating the highway in dense, opaque clouds of blinding fog. Vehicles are seen waiting to continue on their way; it is unclear whether these vehicles attempted to navigate the clouds of tear gas. (Note: Jalopnik reports that this happened on June 2; however, protests consistent with the video were only reported on June 1, and other sources place the video on June 1.)

tags: threaten, tear-gas, vehicle, protester

id: ca-walnutcreek-1

**Links**

* https://www.instagram.com/p/CA7KMc9pX5S/
* https://jalopnik.com/cop-in-armored-truck-tells-peaceful-protesters-if-you-1843886752
* https://abc7news.com/walnut-creek-curfew-tonight-protest-in-today-looting-protests/6231856/
* https://www.kron4.com/news/bay-area/as-protests-remain-mostly-peaceful-walnut-creek-considers-extending-curfew/
* https://www.ktvu.com/news/walnut-creek-police-says-mutual-aid-officer-did-not-say-what-many-thought-they-heard


### Police arrest man using excessive force, dogs | June 1st

Police threw tear gas at protesters blocking a roadway in an effort to disperse them. One protester, Joseph Malott, allegedly threw a tear gas canister back at police. Police arrested him for (per Mercury News) “assaulting a police officer with a deadly weapon.” During the arrest, Malott was bitten and scratched repeatedly by a police dog, leaving bite marks and scratches all over his back and a wound on his leg which required 10 stitches. During the arrest, he says he was slammed against a fence then thrown to the ground, and recalls thinking “when are they going to take the dogs off me?”

tags: arrest, tear-gas, tear-gas-canister, dog, protester

id: ca-walnutcreek-3

**Links**

* https://www.mercurynews.com/2020/06/06/protester-recounts-getting-attacked-by-police-dogs-tear-gassed-at-walnut-creek-demonstration/
* https://sanfrancisco.cbslocal.com/2020/06/17/walnut-creek-police-discuss-protest-response-critics-not-impressed/
* https://www.ktvu.com/news/walnut-creek-police-says-mutual-aid-officer-did-not-say-what-many-thought-they-heard


### Police fire tear gas at peaceful protesters | June 2nd

A small number of peaceful protesters are scattered in the street. Someone shouts, "Get back," and protesters begin running. Shots can be heard and tear gas is fired into the crowd.

tags: tear-gas, protester

id: ca-walnutcreek-2

**Links**

* https://www.tiktok.com/@ieuanofficial/video/6833597510926241029


## Whittier

### Protesters violently arrested without apparent reason | July 29th

Footage shows police grabbing a woman at a protest, forcing her to the ground and arresting her. A male protester attempts to intervene and is arrested as well. The filmer states the victims were his sister and her boyfriend and provided continued updates on their status. She states that when she attempted to call the precinct, she was told that the arrestees had waived their rights and were sleeping and could not be woken up. They were released about 8 hours after being arrested. The filmer responded to a request from 2020PB stating that her sister has been charged with obstruction of justice, battery of an officer, and a crosswalk violation; her boyfriend has been charged with resisting arrest.

tags: arrest, protester

id: ca-whittier-1

**Links**

* https://twitter.com/datLOUDchick/status/1288343247970906112
* https://twitter.com/datLOUDchick/status/1288375164590125056
* https://twitter.com/datLOUDchick/status/1288433203129094145
* https://imgur.com/a/rF83zfJ

