## Notes on neutrality


### Where does 2020PB stand on the protests?

2020PB supports protestors in their call to action on police reforms. However, 2020PB chooses to remain apolitical and prefers at this time to refrain from any affiliation with political groups or specific campaigns.

2020PB does support other groups, like [OpenPolice](OpenPolice.org), who also seek to expand public accountability of police departments.


### Where does 2020PB stand on Law Enforcement?

As an organization, 2020PB treats individual officers  as actors for a system that needs reform. We recognize that there are complex factors involved in the decision to a law enforcement agency and that some officers do join these organizations with positive intentions.

As such we do not tolerate any derogatory language directed at anyone, officers included.


### Objective Language

We understand that strong emotions can arise when viewing the footage, but we feel that the most potent way to display police brutality to the world is with a tone of neutrality.

This means:

* No denigrating, dehumanizing or derogatory language towards police or protestors.
    * Law enforcement officers should be referred to as such: "officers," "police," "agents," "sheriffs," or other department-specific terms. Obviously inflammatory language, like "pigs" or "stormtroopers" should be avoided, as should misleading language like "soldiers."
    * Protestors, unless specifically seen looting, should be referred to as such. They should neither be referred to as "rioters," "looters," and "vandals,"" nor as "heros," "martyrs," or other similar language.
    * No racist, sexist, [queerphobic](https://qmunity.ca/wp-content/uploads/2015/03/Queer_Terminology_Web_Version__Sept_2013__Cover_and_pages_.pdf), ableist or any other such derogatory language is permitted.
* Events should be described without editorialization.
    * There are some terms (see [tags](./docs/tags.md)) allowed that describe physical actions, like shoving or pushing, but inflammatory language should be avoided.
    * This includes terms that presume the motivation of an individual (e.g. officer shoots protestor "for sport.")
* Events should stick to what is visible and what is clear.
    * Do not presume protestors are "peaceful," unless it is seen on camera.
    * Do not rely exclusively on captions to determine the events (e.g. if only one filmer says "rubber bullets" were used, but it cannot be verified, stick to the broader "projectiles.")
    * Present the full context of events. For more on context, see [below](#context).


### Doxxing

2020PB has a strict stance to avoid revealing personal information about anyone, police or protestor. The only exceptions for this are when an incident has become part of a news story, in which personal information is freely shared. This includes interviews with protestors and police, protestor self-identification in incidents, as well as personal information about officers shared by police or federal organizations.


### Context

In order to achieve our goal of neutrality, we believe it is important to provide as much context as possible. While we do not believe peaceful protest or even some acts of rioting by a small number of protestors justify violent police responses against a crowd, we believe it is important to show the context of these incidents.

This includes:
* Events leading up to an incident of police brutality
* Broader protest context (e.g. was a curfew in place? Was looting occurring at or around this site?)
* Protestor behavior (e.g. Did some protestors threaten officers, throw objects, light fires)?
