# Incident Criteria

While the group's name is 2020PoliceBrutality, this moniker does not entirely capture the breadth of incidents the repo intends to include. The repository contains both incidents of police brutality and abuses of power, as defined below.

In addition, there are several filters we apply to keep the incidents focused and the messaging clear. The group finds the tight focus amplifies the weight of incidents by constraining them to a specific time period and circumstance.

These criteria are as follows:

1. Occurring at a protest or in relation to a protest in the aftermath of George Floyd's death.
    * This includes Pride rallies and Trump rallies where police appeared emboldened by violence in other protests and where protestors included Black Lives Matter symbolism, chants or messaging in the protest.
1. US-only protests
    * While protests are, of course, occurring wordlwide, both in solidarity with BLM and for other reasons, the focus is currently on U.S. incidents.
1. Incident shows clear police brutality or abuse of power.
    * See [Categories](#Categories) below for additional info.
1. No incidents of looters, except in cases of clear excessive force (see [ca-vallejo-1](https://github.com/2020PB/police-brutality/blob/master/reports/California.md#police-fatally-shoot-unarmed-22-year-old--june-1st))
1. Direct visual evidence is required.
    * See [No Direct Visual Evidence](#No-direct-visual-evidence) for edge cases

Note: non-protest and non-us incidents are being stored for review. They may be included at a later date.

## Categories

### Police Brutality

1. Use of any riot control rounds or physical violence against bystanders. This includes passersby on foot, homeless people and
1. Use of any riot control rounds or physical violence against children, the elderly or pregnant persons.
1. Use of any riot control rounds against journalists or medics.
1. The use of tear gas at any point.
    * While it has not been studied in depth, there is sufficient antecdotal evidence that tear gas can cause major reproductive harm that 2020PoliceBrutality believes that continued use is inherently brutality.
    * [Comment](https://twitter.com/ProChoiceOH/status/1268253228384292866) from a Pro-Choice Organization stating that tear gas may cause miscarriages
    * [Thread](https://twitter.com/FemFlagCorps/status/1271516751679938560) of antecdotal evidence from Twitter users that tear gas has disrupted their menstrual cycles
    * [ACLU Fact Sheet](https://www.aclu.org/fact-sheet/chemical-irritants-fact-sheet) on considerations for chemical irritant use.
1. The use of a LRAD (or sound cannon) at any point.
    * LRADs are devices designed to emit a sound sufficiently irritating to protestors that they will disperse.
    * Improper use of LRADs is extremely simple. If the settings are modified, the device can easily cause permanent auditory damage to protestors.
    * In addition, the weapon is indiscriminate, affecting police, protestors and bystanders within its radius alike.
    * For more information, see the [ACLU Fact Sheet](https://www.aclu.org/fact-sheet/acoustic-weapons-fact-sheet)
1. Improper use of kinetic projectiles.
    * This includes bean bags, rubber bullets, pepper balls, wooden bullets, plastic bullets, paintballs and other less-lethal munitions.
    * Improper use includes firing at short distance, aiming above the breast bone.
    * See [ACLU Fact Sheet](https://www.aclu.org/fact-sheet/kinetic-impact-projectiles-fact-sheet) on considerations for use.
    * The Fact Sheet states that these weapons are not only dangerous but also ineffective as riot control devices.
1. Use or attempted use of a motor vehicle to strike, scare or chase protestors
1. Use of any riot control rounds against peaceful protestors.
    * This includes use of pepper spray, smoke grenades, flashbangs and kinetic projectiles.
    * See additional [ACLU Fact Sheet](https://www.aclu.org/fact-sheet/disorientation-devices-fact-sheet) on use of disorientation devices (e.g. flashbangs)
    * See additional [ACLU Fact Sheet](https://www.aclu.org/fact-sheet/chemical-irritants-fact-sheet) on considerations for chemical irritant use (e.g. pepper spray).
1. Use of shields, bikes, batons or other objects against peaceful protestors.
1. Kneeling on protestors to make arrests.
    * In particular, this includes kneeling on protestors' necks, as this is the behavior that caused George Floyd's death.
1. Unnecessary violence against protestors (e.g. shoving a protestor for 'walking too slow.')
1. Escalation of violence either without warning or beyond reason.
    * If a protestor strikes an officer without justification, then if officers physically arrest the protestor, this would not be included.
    * However, if an officer strikes a protestor and the protestor responds in kind, police are not justified in escalating to the use of chemical agents or less-lethal munitions.
    * This includes the use of chemical agents or less-lethal munitions if protestors resist being pushed by police (e.g. a police shield line attempts to advance and protestors do not move).


### Abuse of Power

Abuses of power include, but are not limited to:

1. Removal of body cams and/or hiding badges.
1. Racial profiling (e.g. arresting black protestors while allowing white protestors leniency. See [nd-fargo-1](https://github.com/2020PB/police-brutality/blob/master/reports/Ohio.md#man-struck-by-counter-protestor-while-police-look-on--june-14th)).
1. Selectively enforcing laws (e.g. counter-protestors striking protestors without police intervention. See [oh-bethel-1](https://github.com/2020PB/police-brutality/blob/master/reports/Ohio.md#man-struck-by-counter-protestor-while-police-look-on--june-14th))
1. Agitation and incitement (see [Agitation and incitement](#Agitation-and-incitement))
1. Police arresting protestors for protected free speech (see [ga-valdosta-1](https://github.com/2020PB/police-brutality/blob/master/reports/Georgia.md#sheriff-scuffles-with-protestor-over-fck-trump-sign--june-3rd))
1. Inhumane treatment, especially as part of a protected class (see [ca-losangeles-32](https://github.com/2020PB/police-brutality/blob/master/reports/California.md#police-arrest-protesters-en-masse-and-detain-them-in-poor-conditions--june-2nd) and [oh-cincinnati-4](https://github.com/2020PB/police-brutality/blob/master/reports/Ohio.md#officer-refuses-to-give-diabetic-arrestee-her-insulin-back--june-2nd))
1. Destruction of property, particularly medical supplies.

## Edge Cases

The boundary between police brutality, abuse of power, and other issues with the system isn't always clear. This page is meant to call out some edge cases to refine the definition of what content should be curated in this repo and what shouldn't.

### Police speaking words that would incite violence, but not actively violent during this video

- [Cops at Seattle protest brief "don't kill them but hit them hard"](https://www.reddit.com/r/PublicFreakout/comments/gwr1gh/cops_at_a_seattle_protest/)

#### Decision

These incidents are generally excluded, unless accompanied by a use of force (see: [fl-ftlauderdale-3](https://github.com/2020PB/police-brutality/blob/master/reports/Florida.md#police-laugh-and-joke-when-they-think-their-body-cams-are-off--may-31st))


### Selective enforcement, abuse of power, not necessarily excessive force

- [Cops arresting only the black individuals in a line](https://www.reddit.com/r/PublicFreakout/comments/gwm2mf/police_using_selective_enforcement_on_protestors/) ✔️ Added in [#260](https://github.com/2020PB/police-brutality/pull/260)
- [Cops giving warning & preferential treatment to Proud Boys and other white supremacists](ttps://www.buzzfeednews.com/article/davidmack/salem-oregon-cop-warn-white-armed-men-playing-favorites) ✔️ Added in [#626](https://github.com/2020PB/police-brutality/pull/626)

#### Decision

Egregious selective enforcement will be in scope.


### Agitation and incitement

- [Fargo police chief agitated crowd in plain clothes by carrying a beer can and cursing at police.](https://www.grandforksherald.com/opinion/6520779-Port-Fargo-Deputy-Chief-sends-apology-email-after-he-was-seen-at-George-Floyd-protest-with-a-beer-can-cursing-at-law-enforcement) ✔️ Added in [#620](https://github.com/2020PB/police-brutality/pull/620)

#### Decision

Agitation and incitement to riot will be in scope. Apply the `incitement` tag to these reports.


### No direct visual evidence

- [Protester suffered from complications that lead to her death from tear gas](https://twitter.com/ColumbusGov/status/1268295227921641480)


#### Decision

These incidents are less clear. The preference is to include these non-visual as part of incidents with visual evidence.

Indirect submissions are acceptable in some cases:
1. Multiple reporters or verified persons (politicians, celebrities, etc) recount the same or similar events.
1. Submissions are accompanied by direct evidence as part of a broader incident (see: [ca-losangeles-19](https://github.com/2020PB/police-brutality/blob/master/reports/California.md#police-arrest-protesters-en-masse-and-detain-them-in-poor-conditions--june-1st))
1. Eyewitness accounts are provided by reputable sources (news outlets, legal aid groups, etc).


### Police intimidation and indirect threats

- [Police show up at teens house to ask questions about teen's social media posts concerning protests.](https://twitter.com/greg_doucette/status/1268649159952936962) ❌ No direct threats made and nothing for which police could be held accountable. [#627](https://github.com/2020PB/police-brutality/pull/627) was closed.


#### Decision

These incidents are not included.
