
# Police Brutality During the 2020 George Floyd Protests

## Important Note on Branches

On September 15th at 3 PM EDT, the primary branch will be switched from `master` to `main`.

Most tools will use the `data_build` branch, which will not be affected by the change.

---

**New to GitHub? Just want to report an incident?**

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;👇🏽 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;👇🏾<br/>
👉🏿 **[Report it here!](https://github.com/2020PB/police-brutality/issues/new?assignees=&labels=Incident+report&template=incident-report.md&title=Incident+in+CITY%2C+STATE)** 👈🏻<br/>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;👆🏼&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

For more information on contributing to this repository please consult the [contribution guidelines](./CONTRIBUTING.md).

---

This repository exists to accumulate and contextualize evidence of police brutality during the 2020 George Floyd protests.

Our goal in doing this is to assist journalists, politicians, prosecutors, activists and concerned citizens who can use the evidence accumulated here for political campaigns, news reporting, public education and prosecution of criminal police officers.

This was first started as a megathread on the subreddit [/r/2020PoliceBrutality](https://www.reddit.com/r/2020PoliceBrutality) but after being overwhelmed by people looking to contribute, we decided to make a github repository so that everyone who wants to can easily contribute to the project directly.

If you are here looking for evidence of police brutality, please refer to the table of contents for links to incident reports sorted by state.

If you wish to contribute, please start by reading the [contribution guidelines](./CONTRIBUTING.md).

## Links

**Ways to use our incident files:**
* [JSON](https://raw.githubusercontent.com/2020PB/police-brutality/data_build/all-locations-v2.json) / [CSV](https://raw.githubusercontent.com/2020PB/police-brutality/data_build/all-locations.csv) / [MD](https://raw.githubusercontent.com/2020PB/police-brutality/data_build/all-locations.md) API to build your own front end. [Read more](https://github.com/2020PB/police-brutality/tree/data_build)
* [RESTful API](https://www.github.com/949mac/846-backend/) which extends the official Data API through multiple end-points, including `/incidents` with geolocation data, `evidence` inclusion with direct-links to streamable mp4 videos, `/legislators` with House and Senate member contacts, and server-side filtering
* [REST API](https://github.com/nickatnight/policebrutality.io) that points to backed-up video files

**Some projects built using our APIs**
* [A gallery of sites](https://pb2020gallery.netlify.app/) that use the /r/2020PoliceBrutality data. Let us know what you build, and we'll add yours.
* [2020PoliceBrutality](https://2020policebrutality.netlify.app/) web app to visually view incident reports
* [US Police Brutality Map](https://846policebrutality.com/) of incidents with video and social media browsers
* [Too Many Incidents - Searchable](https://too-many-incidents.netlify.app/) collection of incidents and related evidence
* [Android app](https://github.com/amardeshbd/android-police-brutality-incidents) to view incidents sorted by location
* [List of incidents](https://policebrutality.netlify.app/) that you can filter by city and state
* [Pressure Them - Timeline](https://pressurethem.com/policebrutality/) of police brutality events
* [DataStudio - Dashboard](https://datastudio.google.com/s/oFSSsjw2kAY) with stats at the city and state levels
* [Android app](https://github.com/andrewsnyder328/2020PoliceBrutalityApk/) to visually view posts
* [Brutality Visualizer](https://www.brutalityvisualizer.app/) that displays incidents as an interactive heatmap

## Background

On May 25, 2020 an African American man named George Floyd was murdered by police officer Derek Chauvin in Minneapolis, a city with a police department [known for its use of excessive force](https://www.nytimes.com/2020/05/27/us/minneapolis-police.html). George Floyd's murder sparked a wave of protests across the nation as citizens became outraged by another example of police misconduct in the midst of a historic financial and public health crisis caused by the Coronavirus pandemic.

In response to the burgeoning civil unrest, numerous police departments violently cracked down on peaceful demonstrations and drastically escalated confrontations with protesters. As videos of these crack-downs circulated on social media over the following hours and days, the protests escalated nationally and every major city in the country saw mass protests, with some experiencing riots that resulted in mass property destruction and saw buildings burned down.
As these protests have continued, hundreds of incidents have been recorded where police engaged in unprovoked violent assaults, outright police brutality and unprovoked arrests and harassment.

## Table of Contents

* [Contribution Guidelines](./CONTRIBUTING.md)
* [Frequently Asked Questions](./CONTRIBUTING.md#Frequently-Asked-Questions)
* [Building with the API](./docs/building-with-the-api.md)
* [IPFS Archive](https://gateway.temporal.cloud/ipns/2020pb-archive.temporal.cloud)
* [Raw Video Archive (not actively maintained)](https://github.com/pb-files/pb-videos)
* **Incident Reports**
  * [Alabama](./reports/Alabama.md)
  * [Arizona](./reports/Arizona.md)
  * [Arkansas](./reports/Arkansas.md)
  * [California](./reports/California.md)
  * [Colorado](./reports/Colorado.md)
  * [Connecticut](./reports/Connecticut.md)
  * [Delaware](./reports/Delaware.md)
  * [Florida](./reports/Florida.md)
  * [Georgia](./reports/Georgia.md)
  * [Illinois](./reports/Illinois.md)
  * [Indiana](./reports/Indiana.md)
  * [Iowa](./reports/Iowa.md)
  * [Kansas](./reports/Kansas.md)
  * [Kentucky](./reports/Kentucky.md)
  * [Louisiana](./reports/Louisiana.md)
  * [Massachusetts](./reports/Massachusetts.md)
  * [Michigan](./reports/Michigan.md)
  * [Minnesota](./reports/Minnesota.md)
  * [Missouri](./reports/Missouri.md)
  * [Nebraska ](./reports/Nebraska.md)
  * [Nevada](./reports/Nevada.md)
  * [New York](./reports/New%20York.md)
  * [North Carolina](./reports/North%20Carolina.md)
  * [North Dakota](./reports/North%20Dakota.md)
  * [Ohio](./reports/Ohio.md)
  * [Oklahoma](./reports/Oklahoma.md)
  * [Oregon](./reports/Oregon.md)
  * [Pennsylvania](./reports/Pennsylvania.md)
  * [South Carolina](./reports/South%20Carolina.md)
  * [South Dakota](./reports/South%20Dakota.md)
  * [Tennessee](./reports/Tennessee.md)
  * [Texas](./reports/Texas.md)
  * [Utah](./reports/Utah.md)
  * [Vermont](./reports/Vermont.md)
  * [Virginia](./reports/Virginia.md)
  * [Washington](./reports/Washington.md)
  * [Washington D.C.](./reports/Washington%20DC.md)
  * [Wisconsin](./reports/Wisconsin.md)
  * [Unknown Location](./reports/Unknown%20Location.md)
